/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromDependencies;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.fromDependencies.AbstractDependencyFilterMojo;
import org.apache.maven.plugins.dependency.utils.ResolverUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.CollectionTool;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="render-dependencies", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class RenderDependenciesMojo
extends AbstractDependencyFilterMojo {
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Parameter(property="mdep.outputFile")
    private File outputFile;
    @Parameter(property="mdep.classifier", defaultValue="template")
    private String classifier;
    @Parameter(property="mdep.extension", defaultValue="txt")
    private String extension;
    @Parameter(property="mdep.template", required=true)
    private String template;
    private final MavenProjectHelper projectHelper;

    @Inject
    protected RenderDependenciesMojo(MavenSession session, BuildContext buildContext, MavenProject project, ResolverUtil resolverUtil, ProjectBuilder projectBuilder, ArtifactHandlerManager artifactHandlerManager, MavenProjectHelper projectHelper) {
        super(session, buildContext, project, resolverUtil, projectBuilder, artifactHandlerManager);
        this.projectHelper = projectHelper;
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        List<Artifact> artifacts = Optional.ofNullable(this.getResolvedDependencies(true)).orElseGet(Collections::emptySet).stream().sorted(Comparator.comparing(Artifact::getGroupId).thenComparing(Artifact::getArtifactId).thenComparing(Artifact::getBaseVersion).thenComparing(this.orEmpty(Artifact::getClassifier)).thenComparing(this.orEmpty(Artifact::getType))).collect(Collectors.toList());
        if (artifacts.isEmpty()) {
            this.getLog().warn((CharSequence)"No dependencies found.");
        }
        String rendered = this.render(artifacts);
        if (this.outputFile == null) {
            this.getLog().info((CharSequence)rendered);
        } else {
            this.store(rendered, this.outputFile);
        }
        if (this.classifier != null && !this.classifier.isEmpty()) {
            this.attachFile(rendered);
        }
    }

    private String render(List<Artifact> artifacts) {
        Path templatePath = this.getTemplatePath();
        boolean fromFile = templatePath != null && Files.exists(templatePath, new LinkOption[0]);
        Properties props = new Properties();
        props.setProperty("runtime.strict_mode.enable", "true");
        if (fromFile) {
            props.setProperty("resource.loader.file.path", templatePath.toAbsolutePath().getParent().toString());
        }
        VelocityEngine ve = new VelocityEngine(props);
        ve.init();
        VelocityContext context = new VelocityContext();
        context.put("artifacts", artifacts);
        context.put("sorter", (Object)new CollectionTool());
        StringWriter writer = new StringWriter();
        try (StringWriter ignored = writer;){
            if (fromFile) {
                Template template = ve.getTemplate(templatePath.getFileName().toString());
                template.merge((Context)context, (Writer)writer);
            } else {
                ve.evaluate((Context)context, (Writer)writer, "tpl-" + Math.abs(((Object)((Object)this)).hashCode()), this.template);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private Path getTemplatePath() {
        try {
            return Paths.get(this.template, new String[0]);
        }
        catch (RuntimeException re) {
            return null;
        }
    }

    private Comparator<Artifact> orEmpty(Function<Artifact, String> getter) {
        return Comparator.comparing(a -> Optional.ofNullable((String)getter.apply((Artifact)a)).orElse(""));
    }

    protected void attachFile(String content) throws MojoExecutionException {
        File attachedFile;
        if (this.outputFile == null) {
            attachedFile = new File(this.getProject().getBuild().getDirectory(), this.classifier);
            this.store(content, attachedFile);
        } else {
            attachedFile = this.outputFile;
        }
        this.projectHelper.attachArtifact(this.getProject(), this.extension, this.classifier, attachedFile);
    }

    private void store(String content, File out) throws MojoExecutionException {
        Path parent = out.toPath().getParent();
        if (parent != null) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }
        String encoding = Objects.toString(this.outputEncoding, StandardCharsets.UTF_8.name());
        try (BufferedWriter w = Files.newBufferedWriter(out.toPath(), Charset.forName(encoding), new OpenOption[0]);){
            w.write(content);
            this.getLog().info((CharSequence)("Wrote file '" + out + "'."));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error while writing to file '" + out, (Exception)ex);
        }
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

