/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import org.apache.maven.plugins.dependency.tree.AbstractSerializingVisitor;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class DOTDependencyNodeVisitor
extends AbstractSerializingVisitor
implements DependencyNodeVisitor {
    public DOTDependencyNodeVisitor(Writer writer) {
        super(writer);
    }

    public boolean visit(DependencyNode node) {
        try {
            if (node.getParent() == null || node.getParent() == node) {
                this.writer.write("digraph \"" + node.toNodeString() + "\" { " + System.lineSeparator());
                this.writer.flush();
            }
            List children = node.getChildren();
            for (DependencyNode child : children) {
                this.writer.write("\t\"" + node.toNodeString() + "\" -> \"" + child.toNodeString() + "\" ; " + System.lineSeparator());
            }
            this.writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write DOT format output", e);
        }
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        try {
            if (node.getParent() == null || node.getParent() == node) {
                this.writer.write(" } " + System.lineSeparator());
                this.writer.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write DOT format output", e);
        }
        return true;
    }
}

