/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;

public class AddMavenRepoMojo
extends AbstractMojo {
    public static final String DIR_ECLIPSE_PLUGINS_METADATA = ".metadata/.plugins";
    public static final String DIR_ECLIPSE_CORE_RUNTIME_SETTINGS = ".metadata/.plugins/org.eclipse.core.runtime/.settings";
    public static final String FILE_ECLIPSE_JDT_CORE_PREFS = "org.eclipse.jdt.core.prefs";
    public static final String CLASSPATH_VARIABLE_M2_REPO = "org.eclipse.jdt.core.classpathVariable.M2_REPO";
    private String workspace;
    private ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException {
        File workDir = new File(this.workspace, DIR_ECLIPSE_CORE_RUNTIME_SETTINGS);
        workDir.mkdirs();
        Properties props = new Properties();
        File f = new File(workDir, FILE_ECLIPSE_JDT_CORE_PREFS);
        if (f.exists()) {
            try {
                props.load(new FileInputStream(f));
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantreadfile", f.getAbsolutePath()), (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantreadfile", f.getAbsolutePath()), (Exception)e);
            }
        }
        props.put(CLASSPATH_VARIABLE_M2_REPO, this.localRepository.getBasedir());
        try {
            FileOutputStream os = new FileOutputStream(f);
            props.store(os, null);
            ((OutputStream)os).close();
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantwritetofile", f.getAbsolutePath()));
        }
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }
}

