/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.wtp;

import java.io.File;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.ide.JeeUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.XMLWriter;

public abstract class AbstractWtpResourceWriter
extends AbstractEclipseWriter {
    private static final String ELT_DEPENDENCY_TYPE = "dependency-type";
    private static final String ATTR_HANDLE = "handle";
    private static final String ELT_DEPENDENT_MODULE = "dependent-module";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_NAME = "name";
    protected static final String ELT_PROPERTY = "property";
    protected static final String ELT_VERSION = "version";
    protected static final String ATTR_MODULE_TYPE_ID = "module-type-id";
    protected static final String ATTR_SOURCE_PATH = "source-path";
    protected static final String ATTR_DEPLOY_PATH = "deploy-path";
    protected static final String ELT_WB_RESOURCE = "wb-resource";
    protected static final String ELT_MODULE_TYPE = "module-type";
    protected static final String ATTR_DEPLOY_NAME = "deploy-name";
    protected static final String ELT_WB_MODULE = "wb-module";
    protected static final String ATTR_MODULE_ID = "id";
    protected static final String ATTR_PROJECT_VERSION = "project-version";
    protected static final String ELT_PROJECT_MODULES = "project-modules";
    protected static final String ARTIFACT_MAVEN_WAR_PLUGIN = "maven-war-plugin";
    protected static final String ARTIFACT_MAVEN_EAR_PLUGIN = "maven-ear-plugin";

    protected void writeModuleTypeAccordingToPackaging(MavenProject project, XMLWriter writer, File buildOutputDirectory) throws MojoExecutionException {
        if ("war".equals(project.getPackaging())) {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.web");
            writer.startElement(ELT_VERSION);
            writer.writeText(JeeUtils.resolveServletVersion(project));
            writer.endElement();
            String contextRoot = this.config.getContextName();
            writer.startElement(ELT_PROPERTY);
            writer.addAttribute(ATTR_NAME, "context-root");
            writer.addAttribute(ATTR_VALUE, contextRoot);
            writer.endElement();
        } else if ("ejb".equals(this.config.getProject().getPackaging())) {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.ejb");
            writer.startElement(ELT_VERSION);
            writer.writeText(JeeUtils.resolveEjbVersion(project));
            writer.endElement();
            writer.startElement(ELT_PROPERTY);
            writer.addAttribute(ATTR_NAME, "java-output-path");
            writer.addAttribute(ATTR_VALUE, "/" + IdeUtils.toRelativeAndFixSeparator(this.config.getProject().getBasedir(), buildOutputDirectory, false));
            writer.endElement();
        } else if ("ear".equals(this.config.getProject().getPackaging())) {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.ear");
            writer.startElement(ELT_VERSION);
            writer.writeText(JeeUtils.resolveJeeVersion(project));
            writer.endElement();
        } else {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.utility");
            writer.startElement(ELT_PROPERTY);
            writer.addAttribute(ATTR_NAME, "java-output-path");
            writer.addAttribute(ATTR_VALUE, "/" + IdeUtils.toRelativeAndFixSeparator(this.config.getProject().getBasedir(), buildOutputDirectory, false));
            writer.endElement();
        }
    }

    protected void addDependency(XMLWriter writer, IdeDependency dep, ArtifactRepository localRepository, File basedir) throws MojoExecutionException {
        String handle;
        if (dep.isReferencedProject()) {
            handle = "module:/resource/" + dep.getArtifactId() + "/" + dep.getArtifactId();
        } else {
            File artifactPath = dep.getFile();
            if (artifactPath == null) {
                this.log.error((CharSequence)Messages.getString("EclipsePlugin.artifactpathisnull", dep.getId()));
                return;
            }
            String fullPath = artifactPath.getPath();
            File repoFile = new File(fullPath);
            if (dep.isSystemScoped()) {
                handle = "module:/classpath/lib/" + IdeUtils.toRelativeAndFixSeparator(this.config.getEclipseProjectDirectory(), repoFile, false);
            } else {
                File localRepositoryFile = new File(localRepository.getBasedir());
                handle = "module:/classpath/var/M2_REPO/" + IdeUtils.toRelativeAndFixSeparator(localRepositoryFile, repoFile, false);
            }
        }
        writer.startElement(ELT_DEPENDENT_MODULE);
        writer.addAttribute(ATTR_DEPLOY_PATH, "/WEB-INF/lib");
        writer.addAttribute(ATTR_HANDLE, handle);
        writer.startElement(ELT_DEPENDENCY_TYPE);
        writer.writeText("uses");
        writer.endElement();
        writer.endElement();
    }

    protected void writeWarOrEarResources(XMLWriter writer, MavenProject project, ArtifactRepository localRepository) throws MojoExecutionException {
        for (int j = 0; j < this.config.getDeps().length; ++j) {
            IdeDependency dep = this.config.getDeps()[j];
            String type = dep.getType();
            if (dep.isTestDependency() || dep.isProvided() || !"jar".equals(type) && !"ejb".equals(type) && !"ejb-client".equals(type) && !"war".equals(type)) continue;
            this.addDependency(writer, dep, localRepository, this.config.getProject().getBasedir());
        }
    }
}

