/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.gpg.AbstractGpgSigner;
import org.apache.maven.plugins.gpg.BcSigner;
import org.apache.maven.plugins.gpg.GpgSigner;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

public abstract class AbstractGpgMojo
extends AbstractMojo {
    public static final String DEFAULT_ENV_MAVEN_GPG_KEY = "MAVEN_GPG_KEY";
    public static final String DEFAULT_ENV_MAVEN_GPG_FINGERPRINT = "MAVEN_GPG_KEY_FINGERPRINT";
    public static final String DEFAULT_ENV_MAVEN_GPG_PASSPHRASE = "MAVEN_GPG_PASSPHRASE";
    @Parameter(property="gpg.agentSocketLocations", defaultValue=".gnupg/S.gpg-agent")
    private String agentSocketLocations;
    @Parameter(property="gpg.keyFilePath", defaultValue="maven-signing-key.key")
    private String keyFilePath;
    @Parameter(property="gpg.keyFingerprint")
    private String keyFingerprint;
    @Parameter(property="gpg.keyEnvName", defaultValue="MAVEN_GPG_KEY")
    private String keyEnvName;
    @Parameter(property="gpg.keyFingerprintEnvName", defaultValue="MAVEN_GPG_KEY_FINGERPRINT")
    private String keyFingerprintEnvName;
    @Parameter(property="gpg.passphraseEnvName", defaultValue="MAVEN_GPG_PASSPHRASE")
    private String passphraseEnvName;
    @Parameter(property="gpg.homedir")
    private File homedir;
    @Deprecated
    @Parameter(property="gpg.passphrase")
    private String passphrase;
    @Deprecated
    @Parameter(property="gpg.passphraseServerId")
    private String passphraseServerId;
    @Parameter(property="gpg.keyname")
    private String keyname;
    @Parameter(property="gpg.useagent", defaultValue="true")
    private boolean useAgent;
    @Parameter(property="gpg.executable")
    private String executable;
    @Parameter(property="gpg.defaultKeyring", defaultValue="true")
    private boolean defaultKeyring;
    @Deprecated
    @Parameter(property="gpg.secretKeyring")
    private String secretKeyring;
    @Deprecated
    @Parameter(property="gpg.publicKeyring")
    private String publicKeyring;
    @Parameter(property="gpg.lockMode")
    private String lockMode;
    @Parameter(property="gpg.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private List<String> gpgArguments;
    @Parameter(property="gpg.signer", defaultValue="gpg")
    private String signer;
    @Parameter(property="gpg.bestPractices", defaultValue="false")
    private boolean bestPractices;
    @Parameter(property="gpg.terminatePassphrase", defaultValue="true")
    private boolean terminatePassphrase;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Inject
    protected MavenSession session;
    @Inject
    protected SettingsDecrypter settingsDecrypter;
    @Deprecated
    private static final String GPG_PASSPHRASE = "gpg.passphrase";

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (this.bestPractices) {
            this.enforceBestPractices();
        } else if (!this.isNotBlank(this.passphraseServerId)) {
            this.passphraseServerId = GPG_PASSPHRASE;
        }
        this.doExecute();
    }

    protected void enforceBestPractices() throws MojoFailureException {
        if (this.isNotBlank(this.passphrase) || this.isNotBlank(this.passphraseServerId)) {
            throw new MojoFailureException("Do not store passphrase in any file (disk or SCM repository), rely on GnuPG agent or provide passphrase in " + this.passphraseEnvName + " environment variable.");
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    private void logBestPracticeWarning(String source) {
        this.getLog().warn((CharSequence)"");
        this.getLog().warn((CharSequence)"W A R N I N G");
        this.getLog().warn((CharSequence)"");
        this.getLog().warn((CharSequence)"Do not store passphrase in any file (disk or SCM repository),");
        this.getLog().warn((CharSequence)"instead rely on GnuPG agent or provide passphrase in ");
        this.getLog().warn((CharSequence)(this.passphraseEnvName + " environment variable for batch mode."));
        this.getLog().warn((CharSequence)"");
        this.getLog().warn((CharSequence)("Sensitive content loaded from " + source));
        this.getLog().warn((CharSequence)"");
    }

    protected AbstractGpgSigner newSigner(MavenProject mavenProject) throws MojoFailureException {
        AbstractGpgSigner signer = this.createSigner(this.signer);
        signer.setLog(this.getLog());
        signer.setInteractive(this.settings.isInteractiveMode());
        signer.setKeyName(this.keyname);
        signer.setUseAgent(this.useAgent);
        signer.setHomeDirectory(this.homedir);
        signer.setDefaultKeyring(this.defaultKeyring);
        signer.setSecretKeyring(this.secretKeyring);
        signer.setPublicKeyring(this.publicKeyring);
        signer.setLockMode(this.lockMode);
        signer.setArgs(this.gpgArguments);
        signer.setTerminatePassphrase(this.terminatePassphrase);
        String passphrase = (String)this.session.getRepositorySession().getConfigProperties().get("env." + this.passphraseEnvName);
        if (this.isNotBlank(passphrase)) {
            signer.setPassPhrase(passphrase);
        } else if (!this.bestPractices) {
            passphrase = this.passphrase;
            if (this.isNotBlank(passphrase)) {
                this.logBestPracticeWarning("Mojo configuration");
                signer.setPassPhrase(passphrase);
            } else {
                passphrase = this.loadGpgPassphrase();
                if (this.isNotBlank(passphrase)) {
                    this.logBestPracticeWarning("settings.xml");
                    signer.setPassPhrase(passphrase);
                } else {
                    passphrase = this.getPassphrase(mavenProject);
                    if (this.isNotBlank(passphrase)) {
                        this.logBestPracticeWarning("Project properties");
                        signer.setPassPhrase(passphrase);
                    }
                }
            }
        }
        signer.prepare();
        return signer;
    }

    protected AbstractGpgSigner createSigner(String name) throws MojoFailureException {
        AbstractGpgSigner signer;
        if ("gpg".equals(name)) {
            signer = new GpgSigner(this.executable);
        } else if ("bc".equals(name)) {
            signer = new BcSigner(this.session.getRepositorySession(), this.keyEnvName, this.keyFingerprintEnvName, this.agentSocketLocations, this.keyFilePath, this.keyFingerprint);
        } else {
            throw new MojoFailureException("Unknown signer: " + name);
        }
        return signer;
    }

    private boolean isNotBlank(String string) {
        return string != null && !string.trim().isEmpty();
    }

    @Deprecated
    private String loadGpgPassphrase() throws MojoFailureException {
        Server server;
        if (this.isNotBlank(this.passphraseServerId) && (server = this.settings.getServer(this.passphraseServerId)) != null && this.isNotBlank(server.getPassphrase())) {
            SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
            block4: for (SettingsProblem problem : result.getProblems()) {
                switch (problem.getSeverity()) {
                    case WARNING: 
                    case ERROR: {
                        this.getLog().warn((CharSequence)problem.getMessage(), (Throwable)problem.getException());
                        continue block4;
                    }
                    case FATAL: {
                        this.getLog().error((CharSequence)problem.getMessage(), (Throwable)problem.getException());
                        throw new MojoFailureException(problem.getMessage(), (Throwable)problem.getException());
                    }
                }
                throw new IllegalStateException("Unknown severity: " + problem.getSeverity().toString());
            }
            return result.getServer().getPassphrase();
        }
        return null;
    }

    @Deprecated
    public String getPassphrase(MavenProject project) {
        String pass = null;
        if (project != null && (pass = project.getProperties().getProperty(GPG_PASSPHRASE)) == null) {
            MavenProject prj2 = this.findReactorProject(project);
            pass = prj2.getProperties().getProperty(GPG_PASSPHRASE);
        }
        if (project != null && pass != null) {
            this.findReactorProject(project).getProperties().setProperty(GPG_PASSPHRASE, pass);
        }
        return pass;
    }

    @Deprecated
    private MavenProject findReactorProject(MavenProject prj) {
        if (prj.getParent() != null && prj.getParent().getBasedir() != null && prj.getParent().getBasedir().exists()) {
            return this.findReactorProject(prj.getParent());
        }
        return prj;
    }
}

