/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.javadoc.JavadocJarMojo;
import org.apache.maven.plugins.javadoc.resolver.ResourceResolver;
import org.apache.maven.plugins.javadoc.resolver.SourceResolverConfig;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;

@Mojo(name="test-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class TestJavadocJarMojo
extends JavadocJarMojo {
    @Parameter(property="testDoctitle", alias="doctitle", defaultValue="${project.name} ${project.version} Test API")
    private String testDoctitle;
    @Parameter(property="testOverview", alias="overview", defaultValue="${basedir}/src/test/javadoc/overview.html")
    private File testOverview;
    @Parameter(property="testWindowtitle", alias="windowtitle", defaultValue="${project.name} ${project.version} Test API")
    private String testWindowtitle;
    @Parameter(alias="javadocDirectory", defaultValue="${basedir}/src/test/javadoc")
    private File testJavadocDirectory;
    @Parameter(property="maven.javadoc.testClassifier", defaultValue="test-javadoc", required=true)
    private String testClassifier;

    @Inject
    public TestJavadocJarMojo(MavenProjectHelper projectHelper, JarArchiver jarArchiver, SiteTool siteTool, ArchiverManager archiverManager, ResourceResolver resourceResolver, RepositorySystem repoSystem, ArtifactHandlerManager artifactHandlerManager, ProjectBuilder mavenProjectBuilder, ToolchainManager toolchainManager) {
        super(projectHelper, jarArchiver, siteTool, archiverManager, resourceResolver, repoSystem, artifactHandlerManager, mavenProjectBuilder, toolchainManager);
    }

    @Override
    protected String getClassifier() {
        return this.testClassifier;
    }

    @Override
    protected File getJavadocDirectory() {
        return this.testJavadocDirectory;
    }

    @Override
    protected String getDoctitle() {
        return this.testDoctitle;
    }

    @Override
    protected File getOverview() {
        return this.testOverview;
    }

    @Override
    protected String getWindowtitle() {
        return this.testWindowtitle;
    }

    @Override
    protected List<File> getProjectBuildOutputDirs(MavenProject p) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (StringUtils.isNotEmpty((String)p.getBuild().getOutputDirectory())) {
            dirs.add(new File(p.getBuild().getOutputDirectory()));
        }
        if (StringUtils.isNotEmpty((String)p.getBuild().getTestOutputDirectory())) {
            dirs.add(new File(p.getBuild().getTestOutputDirectory()));
        }
        return dirs;
    }

    @Override
    protected List<String> getProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getPackaging().toLowerCase(Locale.ENGLISH))) {
            return Collections.emptyList();
        }
        return p.getTestCompileSourceRoots();
    }

    @Override
    protected List<String> getExecutionProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getExecutionProject().getPackaging().toLowerCase(Locale.ENGLISH))) {
            return Collections.emptyList();
        }
        return p.getExecutionProject().getTestCompileSourceRoots();
    }

    @Override
    protected ScopeDependencyFilter getDependencyScopeFilter() {
        return new ScopeDependencyFilter(Arrays.asList("compile", "provided", "system", "test"), null);
    }

    @Override
    protected SourceResolverConfig configureDependencySourceResolution(SourceResolverConfig config) {
        return super.configureDependencySourceResolution(config).withoutCompileSources().withTestSources();
    }

    @Override
    protected boolean isTest() {
        return true;
    }
}

