/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.filters.AndArtifactFilter;
import org.nuxeo.build.filters.PatternFilterFactory;
import org.nuxeo.build.filters.TransitiveFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyFilter {
    private ArtifactFilter filter;
    private boolean excludeTransitive;
    private String id;
    private String group;
    private String name;
    private String version;
    private String type;
    private String scope;
    private String classifier;
    private String fileName;
    private String trail;
    private MavenProject project;

    public DependencyFilter(MavenProject project) {
        this.project = project;
    }

    public boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    public void setExcludeTransitive(boolean transitive) {
        this.excludeTransitive = transitive;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String file) {
        this.fileName = file;
    }

    public String getTrail() {
        return this.trail;
    }

    public void setTrail(String trail) {
        this.trail = trail;
    }

    public void setFilter(ArtifactFilter filter) {
        this.filter = filter;
    }

    public ArtifactFilter getFilter() {
        if (this.filter == null) {
            ArtifactFilter theFilter;
            AndArtifactFilter andFilter = new AndArtifactFilter();
            if (this.id != null) {
                theFilter = PatternFilterFactory.createIdFilter(this.id);
                andFilter.add(theFilter);
            }
            if (this.group != null) {
                theFilter = PatternFilterFactory.createGroupFilter(this.group);
                andFilter.add(theFilter);
            }
            if (this.name != null) {
                theFilter = PatternFilterFactory.createNameFilter(this.name);
                andFilter.add(theFilter);
            }
            if (this.version != null) {
                theFilter = PatternFilterFactory.createVersionFilter(this.version);
                andFilter.add(theFilter);
            }
            if (this.type != null) {
                theFilter = PatternFilterFactory.createTypeFilter(this.type);
                andFilter.add(theFilter);
            }
            if (this.scope != null) {
                theFilter = PatternFilterFactory.createScopeFilter(this.scope);
                andFilter.add(theFilter);
            }
            if (this.classifier != null) {
                theFilter = PatternFilterFactory.createClassifierFilter(this.classifier);
                andFilter.add(theFilter);
            }
            if (this.fileName != null) {
                theFilter = PatternFilterFactory.createFileFilter(this.fileName);
                andFilter.add(theFilter);
            }
            if (this.trail != null) {
                theFilter = PatternFilterFactory.createTrailFilter(this.trail);
                andFilter.add(theFilter);
            }
            if (this.excludeTransitive) {
                andFilter.add(new TransitiveFilter(this.project, true));
            }
            this.filter = andFilter;
        }
        return this.filter;
    }

    public Collection<Artifact> applyFilters() {
        return this.applyFilters(this.project.getArtifacts());
    }

    public Collection<Artifact> applyFilters(Collection<Artifact> artifacts) {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!this.getFilter().include(artifact)) continue;
            result.add(artifact);
        }
        return result;
    }

    public boolean accept(Artifact artifact) {
        return this.getFilter().include(artifact);
    }

    public Collection<Artifact> applyFilters(Collection<Artifact> artifacts, Collection<Artifact> excluded) {
        if (excluded == null) {
            throw new IllegalArgumentException("excluded argument should not be null ");
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (this.getFilter().include(artifact)) {
                result.add(artifact);
                continue;
            }
            excluded.add(artifact);
        }
        return result;
    }
}

