/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.DependencyFilter;
import org.nuxeo.build.Utils;

public class DependencyFinderMojo
extends AbstractMojo {
    private MavenProject project;
    private String pattern;
    private String group;
    private String name;
    private String version;
    private String type;
    private String scope;
    private String classifier;
    private boolean excludeTransitive;

    public void execute() throws MojoExecutionException {
        DependencyFilter filters = new DependencyFilter(this.project);
        filters.setId(this.pattern);
        filters.setGroup(this.group);
        filters.setName(this.name);
        filters.setVersion(this.version);
        filters.setType(this.type);
        filters.setScope(this.scope);
        filters.setExcludeTransitive(this.excludeTransitive);
        filters.setClassifier(this.classifier);
        Collection<Artifact> artifacts = filters.applyFilters();
        this.getLog().info((CharSequence)" ----------------------------------------------------------------------------");
        this.getLog().info((CharSequence)("Found " + artifacts.size() + " dependency artifacts"));
        this.getLog().info((CharSequence)("    Using pattern filter: " + this.pattern));
        this.getLog().info((CharSequence)("    Exclude transitive dependencies: " + this.excludeTransitive));
        this.getLog().info((CharSequence)" ----------------------------------------------------------------------------");
        System.out.println("");
        System.out.println("");
        for (Artifact artifact : artifacts) {
            System.out.println("===============================================================================");
            System.out.println("Artifact: " + artifact.getId());
            System.out.println("===============================================================================");
            Utils.printArtifactTrail(artifact);
            System.out.println("");
            System.out.println("");
        }
    }
}

