/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.DOMSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectTreeMojo
extends AbstractMojo {
    private MavenProject project;
    private String file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        try {
            Set artifacts = this.project.getArtifacts();
            this.getLog().info((CharSequence)("artifacts " + artifacts.size()));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("project");
            doc.appendChild(root);
            this.createArtifactElement(root, this.project.getArtifact());
            Element dependencies = doc.createElement("dependencies");
            root.appendChild(dependencies);
            for (Artifact artifact : artifacts) {
                this.createArtifactElement(dependencies, artifact);
            }
            if (this.file == null) {
                this.file = "project-tree.xml";
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(this.file)));
            try {
                DOMSerializer.write(doc, (OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("failed to export dependency tree", e);
        }
    }

    protected Element createArtifactElement(Element parent, Artifact artifact) {
        int size;
        Document doc = parent.getOwnerDocument();
        Element element = doc.createElement("artifact");
        parent.appendChild(element);
        element.setAttribute("id", this.project.getArtifact().getId());
        Element property = doc.createElement("group");
        property.setTextContent(artifact.getGroupId());
        element.appendChild(property);
        property = doc.createElement("name");
        property.setTextContent(artifact.getArtifactId());
        element.appendChild(property);
        property = doc.createElement("version");
        property.setTextContent(artifact.getVersion());
        element.appendChild(property);
        property = doc.createElement("scope");
        property.setTextContent(artifact.getScope());
        element.appendChild(property);
        property = doc.createElement("type");
        property.setTextContent(artifact.getType());
        element.appendChild(property);
        property = doc.createElement("classifier");
        property.setTextContent(artifact.getClassifier());
        element.appendChild(property);
        property = doc.createElement("url");
        property.setTextContent(artifact.getDownloadUrl());
        element.appendChild(property);
        property = doc.createElement("file");
        File artifactFile = artifact.getFile();
        if (artifactFile != null) {
            property.setTextContent(artifactFile.getAbsolutePath());
        }
        element.appendChild(property);
        property = doc.createElement("parent");
        List trail = artifact.getDependencyTrail();
        if (trail != null && (size = trail.size()) > 1) {
            String parentId = (String)trail.get(size - 2);
            property.setTextContent(parentId);
        }
        element.appendChild(property);
        return element;
    }
}

