/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class VersionMojo
extends AbstractMojo {
    private MavenProject project;
    private static final String snapTag = "-SNAPSHOT";

    public void execute() throws MojoExecutionException, MojoFailureException {
        String version = this.project.getVersion();
        if (version.length() > 1) {
            String eclipseVersion = this.executeMojo(version);
            this.project.getProperties().setProperty("eclipseVersion", eclipseVersion);
            this.getLog().info((CharSequence)("eclipseVersion:" + eclipseVersion));
        }
    }

    private String executeMojo(String ver) {
        int snapIdx = ver.indexOf(snapTag);
        boolean isSnapshot = snapIdx > 0;
        String eclipseVersion = isSnapshot ? ver.substring(0, snapIdx) : ver;
        eclipseVersion = this.format(eclipseVersion, isSnapshot);
        if (isSnapshot) {
            eclipseVersion = eclipseVersion + snapTag;
        }
        return eclipseVersion;
    }

    private String format(String shortVersion, boolean isSnapshot) {
        if (shortVersion.matches("(\\d+\\.){2}\\d+")) {
            if (isSnapshot) {
                return shortVersion + ".";
            }
            return shortVersion + ".0";
        }
        if (shortVersion.matches("(\\d+\\.)\\d+")) {
            if (isSnapshot) {
                return shortVersion + ".0.";
            }
            return shortVersion + ".0.0";
        }
        return shortVersion;
    }

    public static void main(String[] args) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(new VersionMojo().executeMojo("5.2-SNAPSHOT"), new VersionMojo().executeMojo("5.2"), new VersionMojo().executeMojo("5.1.3-SNAPSHOT"), new VersionMojo().executeMojo("5.1.3")));
        Collections.sort(l);
        System.out.println(l);
    }
}

