/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.nuxeo.build.assembler.xml.ArtifactDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactResolver {
    protected ArtifactRepository local;
    protected List<ArtifactRepository> remoteRepos;
    protected ArtifactFactory factory;
    protected org.apache.maven.artifact.resolver.ArtifactResolver resolver;

    public ArtifactResolver(ArtifactRepository local, List<ArtifactRepository> remoteRepos, org.apache.maven.artifact.resolver.ArtifactResolver resolver, ArtifactFactory factory) {
        this.local = local;
        this.remoteRepos = remoteRepos;
        this.factory = factory;
        this.resolver = resolver;
    }

    public Artifact resolve(ArtifactDescriptor ad) throws MojoExecutionException {
        return this.resolve(ad, "runtime");
    }

    public Artifact resolve(ArtifactDescriptor ad, String scope) throws MojoExecutionException {
        if (ad.group == null || ad.name == null) {
            throw new MojoExecutionException("Invalid artifact descriptor. It should contains at least the groupId and artifactId");
        }
        if (ad.scope == null) {
            ad.scope = scope;
        }
        if (ad.type == null) {
            ad.type = "jar";
        }
        VersionRange vr = null;
        if (ad.version != null) {
            try {
                vr = VersionRange.createFromVersionSpec((String)ad.version);
            }
            catch (InvalidVersionSpecificationException e) {
                e.printStackTrace();
                vr = VersionRange.createFromVersion((String)ad.version);
            }
        }
        Artifact artifact = this.factory.createDependencyArtifact(ad.group, ad.name, vr, ad.type, ad.classifier, ad.scope);
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    public void resolve(Artifact artifact) throws MojoExecutionException {
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
    }
}

