/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler.xml;

import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.filters.OrArtifactFilter;
import org.nuxeo.build.filters.PatternFilterFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="artifact")
public class ArtifactDescriptor {
    @XNode(value="@group")
    public String group;
    @XNode(value="@name")
    public String name;
    @XNode(value="@type")
    public String type;
    @XNode(value="@version")
    public String version;
    @XNode(value="@scope")
    public String scope;
    @XNode(value="@classifier")
    public String classifier;
    @XNode(value="@file")
    public String file;
    @XNode(value="@trail")
    public String trail;
    @XNode(value="@transitive")
    public String transitive;
    @XNode(value="@category")
    public String category;
    @XNode(value="@includeDependsOnCategory")
    public boolean includeDependsOnCategory = true;
    private ArtifactFilter filter;

    public static ArtifactDescriptor fromVersionId(String versionId) {
        String[] ar = StringUtils.split((String)versionId, (char)':', (boolean)false);
        ArtifactDescriptor ad = new ArtifactDescriptor();
        ad.group = ar[0];
        if (ar.length > 1) {
            ad.name = ar[1];
        }
        if (ar.length > 2) {
            ad.version = ar[2];
        }
        if (ar.length > 3) {
            ad.type = ar[3];
        }
        return ad;
    }

    public ArtifactFilter getFilter(AbstractNuxeoAssembler mojo) {
        if (this.filter == null) {
            AndArtifactFilter andFilter = new AndArtifactFilter();
            if (this.group != null) {
                andFilter.add(PatternFilterFactory.createGroupFilter(this.group));
            }
            if (this.name != null) {
                andFilter.add(PatternFilterFactory.createNameFilter(this.name));
            }
            if (this.type != null) {
                andFilter.add(PatternFilterFactory.createTypeFilter(this.type));
            }
            if (this.scope != null) {
                andFilter.add(PatternFilterFactory.createScopeFilter(this.scope));
            }
            if (this.version != null) {
                andFilter.add(PatternFilterFactory.createVersionFilter(this.version));
            }
            if (this.classifier != null) {
                andFilter.add(PatternFilterFactory.createClassifierFilter(this.classifier));
            }
            if (this.file != null) {
                andFilter.add(PatternFilterFactory.createFileFilter(this.file));
            }
            if (this.trail != null) {
                andFilter.add(PatternFilterFactory.createTrailFilter(this.trail));
            }
            if (this.category != null) {
                ArtifactFilter bundleCategoryFilter = PatternFilterFactory.createBundleCategoryFilter(this.category);
                if (this.includeDependsOnCategory) {
                    OrArtifactFilter orFilter = new OrArtifactFilter();
                    orFilter.add(bundleCategoryFilter);
                    orFilter.add(PatternFilterFactory.createDependsOnCategoryFilter(this.category, mojo));
                    andFilter.add((ArtifactFilter)orFilter);
                } else {
                    andFilter.add(bundleCategoryFilter);
                }
            }
            this.filter = andFilter;
        }
        return this.filter;
    }

    public ArtifactFilter getFilter() {
        return this.getFilter(null);
    }
}

