/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.assembler.ArtifactResolver;
import org.nuxeo.build.assembler.NuxeoAssembler;
import org.nuxeo.build.assembler.resource.ArtifactResourceSet;
import org.nuxeo.build.assembler.resource.ResourceSet;
import org.nuxeo.build.assembler.xml.ArtifactDescriptor;
import org.nuxeo.build.filters.OrArtifactFilter;
import org.nuxeo.common.xmap.annotation.XContext;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="artifactSet")
public class ArtifactSet
extends ArtifactResourceSet {
    @XContext(value="mojo")
    protected AbstractNuxeoAssembler mojo;
    @XNode(value="@id")
    protected String id;
    @XNode(value="includeDependencies")
    protected boolean includeDependencies = false;
    @XNode(value="excludeDependencies")
    protected boolean excludeDependencies = false;
    @XNode(value="@extends")
    private String extendedSetId;
    protected ArtifactResourceSet superSet;
    @XNodeList(value="import", type=String[].class, componentType=String.class)
    private String[] importedSets;
    @XNodeList(value="artifacts/artifact", type=ArrayList.class, componentType=ArtifactDescriptor.class)
    private List<ArtifactDescriptor> artifactDescriptors;
    @XNodeList(value="includes/artifact", type=ArrayList.class, componentType=ArtifactDescriptor.class)
    private List<ArtifactDescriptor> includes;
    @XNodeList(value="excludes/artifact", type=ArrayList.class, componentType=ArtifactDescriptor.class)
    private List<ArtifactDescriptor> excludes;
    private ArtifactFilter includeFilter;
    private ArtifactFilter excludeFilter;
    protected Set<Artifact> artifacts;
    private Set<Artifact> resolvedArtifacts;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ArtifactDescriptor> getArtifactDescriptors() {
        return this.artifactDescriptors;
    }

    public void setArtifactDescriptors(List<ArtifactDescriptor> artifacts) {
        this.artifactDescriptors = artifacts;
    }

    public void setMojo(AbstractNuxeoAssembler mojo) {
        this.mojo = mojo;
    }

    public NuxeoAssembler getMojo() {
        return this.mojo;
    }

    public String getExtendedSetId() {
        return this.extendedSetId;
    }

    public void setExtendedSetId(String extendedSetId) {
        this.extendedSetId = extendedSetId;
    }

    public ArtifactResourceSet getSuperSet() {
        return this.superSet;
    }

    public void setSuperSet(ArtifactResourceSet superSet) {
        this.superSet = superSet;
    }

    public String[] getExtendedSets() {
        return this.importedSets;
    }

    public void setExtendedSets(String[] extendedSets) {
        this.importedSets = extendedSets;
    }

    public void setIncludeDependencies(boolean includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    public boolean getIncludeDependencies() {
        return this.includeDependencies;
    }

    public void setExcludeDependencies(boolean excludeDependencies) {
        this.excludeDependencies = excludeDependencies;
    }

    public boolean getExcludeDependencies() {
        return this.excludeDependencies;
    }

    public Set<Artifact> getResolvedArtifacts() {
        return this.resolvedArtifacts;
    }

    public ArtifactFilter getIncludeFilter() {
        if (this.includes == null || this.includes.isEmpty()) {
            return null;
        }
        if (this.includeFilter == null) {
            OrArtifactFilter filter = new OrArtifactFilter();
            for (ArtifactDescriptor artifactDescriptor : this.includes) {
                filter.add(artifactDescriptor.getFilter(this.mojo));
            }
            this.includeFilter = filter;
        }
        return this.includeFilter;
    }

    public ArtifactFilter getExcludeFilter() {
        if (this.excludes == null || this.excludes.isEmpty()) {
            return null;
        }
        if (this.excludeFilter == null) {
            OrArtifactFilter filter = new OrArtifactFilter();
            for (ArtifactDescriptor afd : this.excludes) {
                filter.add(afd.getFilter());
            }
            this.excludeFilter = filter;
        }
        return this.excludeFilter;
    }

    protected Set<Artifact> loadImportedSets() {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Map<String, ResourceSet> sets = this.mojo.getResourceSetMap();
        if (this.importedSets != null && this.importedSets.length > 0) {
            for (String setId : this.importedSets) {
                ResourceSet set = sets.get(setId);
                if (!(set instanceof ArtifactResourceSet)) {
                    this.mojo.getLog().warn((CharSequence)("Cannot extend set " + setId + ". Set not found or not compatible"));
                    continue;
                }
                ArtifactResourceSet arSet = (ArtifactResourceSet)set;
                Iterator<Artifact> it = arSet.artifactIterator();
                while (it.hasNext()) {
                    result.add(it.next());
                }
            }
        }
        return result;
    }

    @Override
    public Set<Artifact> getArtifacts() {
        if (this.artifacts == null) {
            Set<Artifact> deps;
            HashSet<Artifact> result;
            Iterator<Artifact> it;
            ArtifactFilter filter;
            this.artifacts = this.loadImportedSets();
            if (this.superSet != null) {
                this.artifacts.addAll(this.superSet.getArtifacts());
            }
            if ((filter = this.getIncludeFilter()) != null) {
                it = this.artifacts.iterator();
                while (it.hasNext()) {
                    Artifact artifact = it.next();
                    if (filter.include(artifact)) continue;
                    it.remove();
                }
            }
            if (this.includeDependencies) {
                result = new HashSet<Artifact>();
                for (Artifact artifact : this.artifacts) {
                    deps = this.mojo.getArtifactDependencies(artifact);
                    if (deps == null) continue;
                    if (this.mojo.getLog().isDebugEnabled()) {
                        this.mojo.getLog().debug((CharSequence)("add dependencies for " + artifact));
                        for (Artifact dep : deps) {
                            if (result.contains(dep)) continue;
                            this.mojo.getLog().debug((CharSequence)("   added " + dep));
                        }
                    }
                    result.addAll(deps);
                }
                this.artifacts.addAll(result);
            }
            if ((filter = this.getExcludeFilter()) != null) {
                it = this.artifacts.iterator();
                while (it.hasNext()) {
                    if (!filter.include(it.next())) continue;
                    it.remove();
                }
            }
            if (this.excludeDependencies) {
                result = new HashSet();
                for (Artifact artifact : this.artifacts) {
                    deps = this.mojo.getArtifactDependencies(artifact);
                    result.addAll(deps);
                }
                this.artifacts.removeAll(result);
            }
            this.resolveArtifacts(this.artifacts);
            this.collectResolvedArtifacts(this.artifacts);
        }
        return this.artifacts;
    }

    private void resolveArtifacts(Set<Artifact> artifactsToResolve) {
        ArtifactResolver resolver = this.mojo.getArtifactResolver();
        for (Artifact artifact : artifactsToResolve) {
            if (artifact.isResolved()) continue;
            try {
                resolver.resolve(artifact);
            }
            catch (MojoExecutionException e) {
                this.mojo.getLog().warn((Throwable)e);
            }
        }
    }

    public void collectResolvedArtifacts(Set<Artifact> artifactSet) {
        ArtifactResolver resolver = this.mojo.getArtifactResolver();
        try {
            for (ArtifactDescriptor ad : this.artifactDescriptors) {
                Artifact artifact = resolver.resolve(ad);
                if (artifact == null) continue;
                artifactSet.add(artifact);
            }
        }
        catch (MojoExecutionException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        StringBuffer toStringBuffer = new StringBuffer();
        toStringBuffer.append("{" + this.getId() + "," + this.getExtendedSets() + "," + this.getExtendedSetId() + ",includeDependencies=" + this.getIncludeDependencies() + ",resolvedArtifacts=" + this.getResolvedArtifacts() + ", " + this.getArtifacts().size() + " artifacts=" + this.getArtifacts());
        return toStringBuffer.toString();
    }
}

