/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler.xml;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.assembler.FileSetFilter;
import org.nuxeo.build.assembler.resource.FileResource;
import org.nuxeo.build.assembler.resource.FileResourceSet;
import org.nuxeo.build.assembler.resource.Resource;
import org.nuxeo.build.assembler.resource.ResourceIterator;
import org.nuxeo.build.assembler.resource.ResourceSet;
import org.nuxeo.build.assembler.xml.ExcludePatterns;
import org.nuxeo.build.assembler.xml.IncludePatterns;
import org.nuxeo.common.utils.FileTreeIterator;
import org.nuxeo.common.xmap.annotation.XContext;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="fileSet")
public class FileSet
extends FileResourceSet {
    @XContext(value="mojo")
    private AbstractNuxeoAssembler mojo;
    @XNode(value="@id")
    private String id;
    @XNodeList(value="extends", type=String[].class, componentType=String.class)
    private String[] extendedSets;
    @XNode(value="directory")
    private String directory;
    @XNode(value="includes")
    private IncludePatterns includes;
    @XNode(value="excludes")
    private ExcludePatterns excludes;
    private Set<File> files;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public IncludePatterns getIncludes() {
        return this.includes;
    }

    public void setIncludes(IncludePatterns includes) {
        this.includes = includes;
    }

    public ExcludePatterns getExcludes() {
        return this.excludes;
    }

    public void setExcludes(ExcludePatterns excludes) {
        this.excludes = excludes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String[] getExtendedSets() {
        return this.extendedSets;
    }

    public void setExtendedSets(String[] extendedSets) {
        this.extendedSets = extendedSets;
    }

    private Set<File> loadBaseSets() {
        HashSet<File> result = new HashSet<File>();
        if (this.extendedSets != null && this.extendedSets.length > 0) {
            for (String setId : this.extendedSets) {
                Map<String, ResourceSet> sets = this.mojo.getResourceSetMap();
                ResourceSet set = sets.get(setId);
                if (set instanceof FileResourceSet) {
                    FileResourceSet frSet = (FileResourceSet)set;
                    Iterator<File> it = frSet.fileIterator();
                    while (it.hasNext()) {
                        result.add(it.next());
                    }
                    continue;
                }
                this.mojo.getLog().warn((CharSequence)("Base set not found or incompatible type: " + setId));
            }
        }
        return result;
    }

    @Override
    public Iterator<File> fileIterator() {
        if (this.files == null) {
            this.files = new HashSet<File>();
            Set<File> base = this.loadBaseSets();
            File dir = new File(this.mojo.getBasedir(), this.directory);
            FileTreeIterator it = new FileTreeIterator(dir, true);
            IncludePatterns includePatterns = this.getIncludes();
            ExcludePatterns excludePatterns = this.getExcludes();
            if (includePatterns != null || excludePatterns != null) {
                it.setFilter((FileFilter)new FileSetFilter(dir, includePatterns, excludePatterns));
            }
            while (it.hasNext()) {
                this.files.add(it.next());
            }
            if (includePatterns != null) {
                for (File file : base) {
                    if (!includePatterns.match(file.getAbsolutePath())) continue;
                    this.files.add(file);
                }
            }
            if (excludePatterns != null) {
                for (File file : base) {
                    if (!excludePatterns.match(file.getAbsolutePath())) continue;
                    this.files.remove(file);
                }
            }
        }
        return this.files.iterator();
    }

    @Override
    public Iterator<Resource> iterator() {
        String prefix = new File(this.mojo.getBasedir(), this.directory).getAbsolutePath();
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        final int off = prefix.length();
        return new ResourceIterator<File>(this.fileIterator()){

            @Override
            protected Resource adapt(File object) {
                return new FileResource(object.getAbsolutePath().substring(off), object);
            }
        };
    }

    public String toString() {
        StringBuffer toStringBuffer = new StringBuffer();
        toStringBuffer.append("{" + this.getId() + "," + this.getExtendedSets() + "," + this.getDirectory() + "," + this.getIncludes() + "," + this.getExcludes());
        return toStringBuffer.toString();
    }
}

