/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.assembler.NuxeoAssembler;
import org.nuxeo.build.assembler.resource.FileResource;
import org.nuxeo.build.assembler.resource.Resource;
import org.nuxeo.build.assembler.resource.ResourceSet;
import org.nuxeo.build.assembler.resource.ZipEntryResource;
import org.nuxeo.common.xmap.annotation.XContext;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="files")
public class Files
implements ResourceSet {
    @XContext(value="mojo")
    private AbstractNuxeoAssembler mojo;
    @XNode(value="@id")
    private String id;
    @XNodeList(value="file", type=String[].class, componentType=String.class)
    private String[] files;
    @XNodeList(value="extends", type=String[].class, componentType=String.class)
    private String[] extendedSets;

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public NuxeoAssembler getMojo() {
        return this.mojo;
    }

    public void setMojo(AbstractNuxeoAssembler mojo) {
        this.mojo = mojo;
    }

    public String[] getExtendedSets() {
        return this.extendedSets;
    }

    public void setExtendedSets(String[] extendedSets) {
        this.extendedSets = extendedSets;
    }

    @Override
    public Iterator<Resource> iterator() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (this.files != null) {
            for (String path : this.files) {
                File file;
                int p = (path = this.mojo.expandVars(path)).indexOf(33);
                if (p > 0) {
                    file = new File(path.substring(0, p));
                    try {
                        result.add(new ZipEntryResource(path.substring(p + 1), file));
                        continue;
                    }
                    catch (IOException e) {
                        throw new Error("Failed to create zip entry resource for " + path, e);
                    }
                }
                file = new File(path);
                result.add(new FileResource(file.getName(), file));
            }
        }
        return result.iterator();
    }
}

