/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.filters;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

public abstract class AbstractPatternFilter
implements ArtifactFilter {
    protected char[] pattern;

    protected abstract String getValueToMatch(Artifact var1);

    public AbstractPatternFilter(String pattern) {
        this(pattern.toCharArray());
    }

    public AbstractPatternFilter(char[] pattern) {
        this.pattern = pattern;
    }

    public void setPattern(char[] pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern.toCharArray();
    }

    public char[] getPattern() {
        return this.pattern;
    }

    public boolean include(Artifact artifact) {
        return AbstractPatternFilter.matchPattern(this.getValueToMatch(artifact), this.pattern);
    }

    public static boolean matchPattern(String name, char[] pattern) {
        return AbstractPatternFilter.matchPattern(name.toCharArray(), pattern);
    }

    public static boolean matchPattern(char[] name, char[] pattern) {
        return AbstractPatternFilter.matchPattern(name, 0, name.length, pattern);
    }

    public static boolean matchPattern(char[] name, int offset, int len, char[] pattern) {
        int i = offset;
        boolean wildcard = false;
        block4: for (char c : pattern) {
            switch (c) {
                case '*': {
                    wildcard = true;
                    continue block4;
                }
                case '?': {
                    ++i;
                    continue block4;
                }
                default: {
                    if (wildcard) {
                        while (i < len && name[i++] != c) {
                        }
                        if (i == len) {
                            return true;
                        }
                        wildcard = false;
                        continue block4;
                    }
                    if (i >= len || name[i] != c) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        return wildcard || i == len;
    }
}

