/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.filters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyRequiredPatternFilter
implements ArtifactFilter {
    private AbstractNuxeoAssembler mojo;
    private static Map<String, Set<String>> requiredDependenciesByPattern;
    protected String pattern;

    public DependencyRequiredPatternFilter(String pattern, AbstractNuxeoAssembler mojo) {
        this.mojo = mojo;
        this.pattern = pattern;
        if (requiredDependenciesByPattern == null) {
            requiredDependenciesByPattern = new HashMap<String, Set<String>>();
        }
    }

    public boolean include(Artifact artifact) {
        return this.getRequiredDependencies().contains(artifact.getId());
    }

    private Set<String> getRequiredDependencies() {
        if (!requiredDependenciesByPattern.containsKey(this.pattern)) {
            requiredDependenciesByPattern.put(this.pattern, new HashSet());
        }
        return requiredDependenciesByPattern.get(this.pattern);
    }

    public void add(Set<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            this.add(artifact);
        }
    }

    public void add(Artifact artifact) {
        this.getRequiredDependencies().add(artifact.getId());
        this.mojo.getLog().debug((CharSequence)("add in requiredDependencies: " + artifact));
    }
}

