/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.filters;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.filters.PatternFilterFactory;

public class DependsOnCategoryPatternFilter
implements ArtifactFilter {
    private AbstractNuxeoAssembler mojo;
    private ArtifactFilter categoryFilter;

    public DependsOnCategoryPatternFilter(String pattern, AbstractNuxeoAssembler mojo) {
        this.mojo = mojo;
        this.categoryFilter = PatternFilterFactory.createBundleCategoryFilter(pattern);
    }

    public boolean include(Artifact artifact) {
        boolean include = false;
        Set<Artifact> dependencies = this.mojo.getArtifactDependencies(artifact);
        this.mojo.getLog().debug((CharSequence)(DependsOnCategoryPatternFilter.class + " filtering " + artifact + " ..."));
        if (dependencies != null) {
            for (Artifact dependency : dependencies) {
                Artifact resolvedDependency = this.mojo.getArtifact(dependency);
                if (this.categoryFilter.include(resolvedDependency)) {
                    this.mojo.getLog().debug((CharSequence)("accepts " + resolvedDependency));
                    include = true;
                    break;
                }
                this.mojo.getLog().debug((CharSequence)("rejects " + resolvedDependency));
            }
        }
        this.mojo.getLog().debug((CharSequence)("filtering result for " + artifact + " : " + include));
        return include;
    }
}

