/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.filters;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.nuxeo.build.filters.AbstractPatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestBundleCategoryPatternFilter
extends AbstractPatternFilter {
    public static String MANIFEST_BUNDLE_CATEGORY = "Bundle-Category";
    public static String MANIFEST_BUNDLE_CATEGORY_TOKEN = ",";
    private Log log = new SystemStreamLog();

    public ManifestBundleCategoryPatternFilter(String pattern) {
        super(pattern);
    }

    public ManifestBundleCategoryPatternFilter(char[] pattern) {
        super(pattern);
    }

    protected List<String> getValuesToMatch(Artifact artifact) {
        ArrayList<String> valuesToMatch = new ArrayList<String>();
        File file = artifact.getFile();
        if (file == null) {
            if (artifact.isResolved()) {
                this.log.warn((CharSequence)("Artifact " + artifact + " doesn't contain a file"));
            } else {
                this.log.warn((CharSequence)("Artifact " + artifact + " unresolved"));
            }
            return valuesToMatch;
        }
        try {
            JarFile jarFile = new JarFile(file, true);
            Manifest mf = jarFile.getManifest();
            if (mf != null) {
                String bundleCategories;
                Attributes attributes = mf.getMainAttributes();
                if (attributes != null && (bundleCategories = attributes.getValue(MANIFEST_BUNDLE_CATEGORY)) != null) {
                    StringTokenizer st = new StringTokenizer(bundleCategories, MANIFEST_BUNDLE_CATEGORY_TOKEN);
                    while (st.hasMoreTokens()) {
                        valuesToMatch.add(st.nextToken());
                    }
                }
            } else {
                this.log.warn((CharSequence)("Artifact " + artifact + " doesn't contain a manifest"));
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)("error while inspecting this jar manifest: " + artifact.getFile()), (Throwable)e);
        }
        return valuesToMatch;
    }

    @Override
    protected String getValueToMatch(Artifact artifact) {
        return null;
    }

    @Override
    public boolean include(Artifact artifact) {
        return this.matchPattern(this.getValuesToMatch(artifact));
    }

    private boolean matchPattern(List<String> valuesToMatch) {
        for (String valueToMatch : valuesToMatch) {
            if (!ManifestBundleCategoryPatternFilter.matchPattern(valueToMatch, this.pattern)) continue;
            return true;
        }
        return false;
    }
}

