/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.relocation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugins.shade.relocation.Relocator;

public class SimpleRelocator
implements Relocator {
    private String pattern;
    private String pathPattern;
    private String shadedPattern;
    private String shadedPathPattern;
    private List excludes;

    public SimpleRelocator(String patt, String shadedPattern, List excludes) {
        this.pattern = patt;
        this.pathPattern = patt.replace('.', '/');
        if (shadedPattern != null) {
            this.shadedPattern = shadedPattern;
            this.shadedPathPattern = shadedPattern.replace('.', '/');
        } else {
            this.shadedPattern = "hidden." + this.pattern;
            this.shadedPathPattern = "hidden/" + this.pathPattern;
        }
        if (excludes != null) {
            this.excludes = new ArrayList();
            Iterator i = excludes.iterator();
            while (i.hasNext()) {
                String e = (String)i.next();
                this.excludes.add(e.replace('.', '/'));
            }
        }
    }

    public boolean canRelocatePath(String clazz) {
        if (this.excludes != null) {
            Iterator i = this.excludes.iterator();
            while (i.hasNext()) {
                String exclude = (String)i.next();
                if (exclude.endsWith("/*") && clazz.startsWith(exclude.substring(0, exclude.length() - 2))) {
                    return false;
                }
                if (!clazz.equals(exclude)) continue;
                return false;
            }
        }
        return clazz.startsWith(this.pathPattern);
    }

    public boolean canRelocateClass(String clazz) {
        if (this.excludes != null) {
            Iterator i = this.excludes.iterator();
            while (i.hasNext()) {
                String exclude = (String)i.next();
                if ((exclude = exclude.replace('/', '.')).endsWith(".*") && clazz.startsWith(exclude.substring(0, exclude.length() - 2))) {
                    return false;
                }
                if (!clazz.equals(exclude)) continue;
                return false;
            }
        }
        return clazz.startsWith(this.pattern);
    }

    public String relocatePath(String clazz) {
        return clazz.replaceFirst(this.pathPattern, this.shadedPathPattern);
    }

    public String relocateClass(String clazz) {
        return clazz.replaceFirst(this.pattern, this.shadedPattern);
    }
}

