/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.List;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapVersionsPhase
extends AbstractReleasePhase {
    private boolean convertToSnapshot;
    private boolean convertToBranch;
    private Prompter prompter;

    void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        if (releaseDescriptor.isAutoVersionSubmodules() && ArtifactUtils.isSnapshot((String)rootProject.getVersion())) {
            MavenProject project = rootProject;
            String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            String nextVersion = this.getNextVersion(project, projectId, releaseDescriptor, result);
            if (this.convertToSnapshot) {
                if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                    releaseDescriptor.mapReleaseVersion(projectId, nextVersion);
                } else {
                    releaseDescriptor.mapDevelopmentVersion(projectId, nextVersion);
                }
            } else {
                releaseDescriptor.mapReleaseVersion(projectId, nextVersion);
            }
            for (MavenProject subProject : reactorProjects) {
                String subProjectId = ArtifactUtils.versionlessKey((String)subProject.getGroupId(), (String)subProject.getArtifactId());
                if (this.convertToSnapshot) {
                    String v = ArtifactUtils.isSnapshot((String)subProject.getVersion()) ? nextVersion : subProject.getVersion();
                    if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                        releaseDescriptor.mapReleaseVersion(subProjectId, v);
                        continue;
                    }
                    releaseDescriptor.mapDevelopmentVersion(subProjectId, v);
                    continue;
                }
                releaseDescriptor.mapReleaseVersion(subProjectId, nextVersion);
            }
        } else {
            for (MavenProject project : reactorProjects) {
                String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                String nextVersion = this.getNextVersion(project, projectId, releaseDescriptor, result);
                if (this.convertToSnapshot) {
                    if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                        releaseDescriptor.mapReleaseVersion(projectId, nextVersion);
                        continue;
                    }
                    releaseDescriptor.mapDevelopmentVersion(projectId, nextVersion);
                    continue;
                }
                releaseDescriptor.mapReleaseVersion(projectId, nextVersion);
            }
        }
        result.setResultCode(0);
        return result;
    }

    private String getNextVersion(MavenProject project, String projectId, ReleaseDescriptor releaseDescriptor, ReleaseResult result) throws ReleaseExecutionException {
        String nextVersion = null;
        DefaultVersionInfo currentVersionInfo = null;
        DefaultVersionInfo releaseVersionInfo = null;
        boolean releaseVersionIsExplicit = false;
        VersionInfo nextSnapshotVersionInfo = null;
        boolean nextSnapshotVersionIsExplicit = false;
        try {
            String nextDevVersion;
            String releaseVersion;
            releaseVersionInfo = currentVersionInfo = new DefaultVersionInfo(project.getVersion());
            if (releaseDescriptor.getDefaultReleaseVersion() != null) {
                releaseVersionInfo = new DefaultVersionInfo(releaseDescriptor.getDefaultReleaseVersion());
                releaseVersionIsExplicit = true;
            }
            if (releaseDescriptor.getReleaseVersions() != null && (releaseVersion = (String)releaseDescriptor.getReleaseVersions().get(projectId)) != null) {
                releaseVersionInfo = new DefaultVersionInfo(releaseVersion);
                releaseVersionIsExplicit = true;
            }
            nextSnapshotVersionInfo = releaseVersionInfo.getNextVersion();
            if (releaseDescriptor.getDefaultDevelopmentVersion() != null) {
                nextSnapshotVersionInfo = new DefaultVersionInfo(releaseDescriptor.getDefaultDevelopmentVersion());
                nextSnapshotVersionIsExplicit = true;
            }
            if (releaseDescriptor.getDevelopmentVersions() != null && (nextDevVersion = (String)releaseDescriptor.getDevelopmentVersions().get(projectId)) != null) {
                nextSnapshotVersionInfo = new DefaultVersionInfo(nextDevVersion);
                nextSnapshotVersionIsExplicit = true;
            }
        }
        catch (VersionParseException e) {
            String msg = "Error parsing version, cannot determine next version: " + e.getMessage();
            if (releaseDescriptor.isInteractive()) {
                this.logWarn(result, msg);
                this.logDebug(result, e.getMessage(), e);
                if (releaseVersionInfo == null) {
                    try {
                        releaseVersionInfo = new DefaultVersionInfo("1.0");
                    }
                    catch (VersionParseException e1) {
                        throw new ReleaseExecutionException("Version 1.0 could not be parsed!", e1);
                    }
                }
                if (nextSnapshotVersionInfo == null) {
                    nextSnapshotVersionInfo = releaseVersionInfo.getNextVersion();
                }
            }
            throw new ReleaseExecutionException(msg, e);
        }
        try {
            if (this.convertToSnapshot) {
                if (releaseDescriptor.isBranchCreation()) {
                    if (this.convertToBranch) {
                        if (releaseDescriptor.isUpdateBranchVersions() && (ArtifactUtils.isSnapshot((String)project.getVersion()) || releaseDescriptor.isUpdateVersionsToSnapshot())) {
                            nextVersion = releaseVersionInfo.getSnapshotVersionString();
                            if (!releaseVersionIsExplicit && releaseDescriptor.isInteractive()) {
                                nextVersion = this.prompter.prompt("What is the branch version for \"" + project.getName() + "\"? (" + projectId + ")", nextVersion);
                            }
                        } else {
                            nextVersion = project.getVersion();
                        }
                    } else if (ArtifactUtils.isSnapshot((String)project.getVersion()) && releaseDescriptor.isUpdateWorkingCopyVersions()) {
                        nextVersion = nextSnapshotVersionInfo.getSnapshotVersionString();
                        if (releaseDescriptor.isInteractive() && !nextSnapshotVersionIsExplicit) {
                            nextVersion = this.prompter.prompt("What is the new working copy version for \"" + project.getName() + "\"? (" + projectId + ")", nextVersion);
                        }
                    } else {
                        nextVersion = project.getVersion();
                    }
                } else {
                    nextVersion = nextSnapshotVersionInfo.getSnapshotVersionString();
                    if (releaseDescriptor.isInteractive() && !nextSnapshotVersionIsExplicit) {
                        nextVersion = this.prompter.prompt("What is the new development version for \"" + project.getName() + "\"? (" + projectId + ")", nextVersion);
                    }
                }
            } else if (ArtifactUtils.isSnapshot((String)project.getVersion())) {
                nextVersion = releaseVersionInfo.getReleaseVersionString();
                if (releaseDescriptor.isInteractive() && !releaseVersionIsExplicit) {
                    nextVersion = this.prompter.prompt("What is the release version for \"" + project.getName() + "\"? (" + projectId + ")", nextVersion);
                }
            } else {
                nextVersion = project.getVersion();
            }
        }
        catch (PrompterException e) {
            throw new ReleaseExecutionException("Error reading version from input handler: " + e.getMessage(), e);
        }
        return nextVersion;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
        result.setResultCode(0);
        return result;
    }
}

