/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.tag;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListCommand;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitTagCommand
extends AbstractTagCommand
implements GitCommand {
    private final Map<String, String> environmentVariables;

    public GitTagCommand(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, String message) throws ScmException {
        return this.executeTagCommand(repo, fileSet, tag, new ScmTagParameters(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, ScmTagParameters scmTagParameters) throws ScmException {
        if (tag == null) throw new ScmException("tag name must be specified");
        if (tag.trim().isEmpty()) {
            throw new ScmException("tag name must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory");
        }
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)"UTF-8", (String)scmTagParameters.getMessage());
        }
        catch (IOException ex) {
            return new TagScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        try {
            Commandline clPush;
            CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
            Commandline clTag = GitTagCommand.createCommandLine(repository, fileSet.getBasedir(), tag, messageFile, scmTagParameters.getSignOption());
            int exitCode = GitCommandLineUtils.execute(clTag, stdout, stderr);
            if (exitCode != 0) {
                TagScmResult tagScmResult = new TagScmResult(clTag.toString(), "The git-tag command failed.", stderr.getOutput(), false);
                return tagScmResult;
            }
            if (repo.isPushChanges() && (exitCode = GitCommandLineUtils.execute(clPush = this.createPushCommandLine(repository, fileSet, tag), stdout, stderr)) != 0) {
                TagScmResult tagScmResult = new TagScmResult(clPush.toString(), "The git-push command failed.", stderr.getOutput(), false);
                return tagScmResult;
            }
            GitListConsumer listConsumer = new GitListConsumer(fileSet.getBasedir(), ScmFileStatus.TAGGED);
            Commandline clList = GitListCommand.createCommandLine(repository, fileSet.getBasedir());
            exitCode = GitCommandLineUtils.execute(clList, (StreamConsumer)listConsumer, stderr);
            if (exitCode != 0) {
                CheckOutScmResult checkOutScmResult = new CheckOutScmResult(clList.toString(), "The git-ls-files command failed.", stderr.getOutput(), false);
                return checkOutScmResult;
            }
            TagScmResult tagScmResult = new TagScmResult(clTag.toString(), listConsumer.getListedFiles());
            return tagScmResult;
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException iOException) {}
        }
    }

    static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, String tag, File messageFile, CommandParameters.SignOption signOption) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "tag");
        switch (signOption) {
            case FORCE_SIGN: {
                cl.createArg().setValue("-s");
                break;
            }
            case FORCE_NO_SIGN: {
                cl.createArg().setValue("--no-sign");
                break;
            }
        }
        cl.createArg().setValue("-F");
        cl.createArg().setValue(messageFile.getAbsolutePath());
        cl.createArg().setValue(tag);
        return cl;
    }

    public Commandline createPushCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet, String tag) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "push", repository, this.environmentVariables);
        cl.createArg().setValue(repository.getPushUrl());
        cl.createArg().setValue("refs/tags/" + tag);
        return cl;
    }
}

