/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.checkout;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.checkout.PerforceCheckOutConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceCheckOutCommand
extends AbstractCheckOutCommand
implements PerforceCommand {
    private String actualLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet files, ScmVersion version) throws ScmException {
        CheckOutScmResult checkOutScmResult;
        boolean clientspecExists;
        Commandline cl;
        PerforceCheckOutConsumer consumer;
        String specname;
        File workingDirectory;
        PerforceScmProviderRepository prepo;
        block33: {
            prepo = (PerforceScmProviderRepository)repo;
            workingDirectory = new File(files.getBasedir().getAbsolutePath());
            this.actualLocation = PerforceScmProvider.getRepoPath(this.getLogger(), prepo, files.getBasedir());
            specname = PerforceScmProvider.getClientspecName(this.getLogger(), prepo, workingDirectory);
            consumer = new PerforceCheckOutConsumer(specname, this.actualLocation);
            this.getLogger().info("Checkout working directory: " + workingDirectory);
            cl = null;
            try {
                String line;
                cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                cl.createArgument().setValue("client");
                cl.createArgument().setValue("-i");
                this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                Process proc = cl.execute();
                OutputStream out = proc.getOutputStream();
                DataOutputStream dos = new DataOutputStream(out);
                String client = PerforceScmProvider.createClientspec(this.getLogger(), prepo, workingDirectory, this.actualLocation);
                this.getLogger().debug("Updating clientspec:\n" + client);
                dos.write(client.getBytes());
                dos.close();
                out.close();
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while ((line = br.readLine()) != null) {
                    this.getLogger().debug("Consuming: " + line);
                    consumer.consumeLine(line);
                }
                br.close();
                BufferedReader brErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                while ((line = brErr.readLine()) != null) {
                    this.getLogger().debug("Consuming stderr: " + line);
                    consumer.consumeLine(line);
                }
                brErr.close();
            }
            catch (IOException e) {
                this.getLogger().error((Throwable)e);
            }
            catch (CommandLineException e) {
                this.getLogger().error((Throwable)e);
            }
            clientspecExists = consumer.isSuccess();
            if (clientspecExists) {
                try {
                    String line;
                    cl = PerforceCheckOutCommand.createCommandLine(prepo, workingDirectory, version, specname);
                    this.getLogger().debug("Executing: " + PerforceScmProvider.clean(cl.toString()));
                    Process proc = cl.execute();
                    BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = br.readLine()) != null) {
                        this.getLogger().debug("Consuming: " + line);
                        consumer.consumeLine(line);
                    }
                    br.close();
                    BufferedReader brErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    while ((line = brErr.readLine()) != null) {
                        this.getLogger().debug("Consuming stderr: " + line);
                        consumer.consumeLine(line);
                    }
                    brErr.close();
                    this.getLogger().debug("Perforce sync complete.");
                }
                catch (IOException e) {
                    this.getLogger().error((Throwable)e);
                }
                catch (CommandLineException e) {
                    this.getLogger().error((Throwable)e);
                }
            }
            if (!consumer.isSuccess()) break block33;
            checkOutScmResult = new CheckOutScmResult(cl.toString(), consumer.getCheckedout());
            Object var17_21 = null;
            if (clientspecExists && !prepo.isPersistCheckout()) {
                try {
                    String line;
                    cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                    cl.createArgument().setValue("client");
                    cl.createArgument().setValue("-d");
                    cl.createArgument().setValue(specname);
                    this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                    Process proc = cl.execute();
                    BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = br.readLine()) != null) {
                        this.getLogger().debug("Consuming: " + line);
                        consumer.consumeLine(line);
                    }
                    br.close();
                    BufferedReader brErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    while ((line = brErr.readLine()) != null) {
                        this.getLogger().debug("Consuming stderr: " + line);
                        consumer.consumeLine(line);
                    }
                    brErr.close();
                }
                catch (CommandLineException e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
            } else if (clientspecExists) {
                System.setProperty("maven.scm.perforce.clientspec.name", specname);
            }
            return checkOutScmResult;
        }
        try {
            checkOutScmResult = new CheckOutScmResult(cl.toString(), "Unable to sync.  Are you logged in?", consumer.getOutput(), consumer.isSuccess());
            Object var17_22 = null;
        }
        catch (Throwable throwable) {
            block35: {
                block34: {
                    Object var17_23 = null;
                    if (!clientspecExists || prepo.isPersistCheckout()) break block34;
                    try {
                        String line;
                        cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                        cl.createArgument().setValue("client");
                        cl.createArgument().setValue("-d");
                        cl.createArgument().setValue(specname);
                        this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                        Process proc = cl.execute();
                        BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        while ((line = br.readLine()) != null) {
                            this.getLogger().debug("Consuming: " + line);
                            consumer.consumeLine(line);
                        }
                        br.close();
                        BufferedReader brErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        while ((line = brErr.readLine()) != null) {
                            this.getLogger().debug("Consuming stderr: " + line);
                            consumer.consumeLine(line);
                        }
                        brErr.close();
                    }
                    catch (CommandLineException e) {
                        this.getLogger().error(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        this.getLogger().error(e.getMessage(), (Throwable)e);
                    }
                    break block35;
                }
                if (!clientspecExists) break block35;
                System.setProperty("maven.scm.perforce.clientspec.name", specname);
            }
            throw throwable;
        }
        if (clientspecExists && !prepo.isPersistCheckout()) {
            try {
                String line;
                cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                cl.createArgument().setValue("client");
                cl.createArgument().setValue("-d");
                cl.createArgument().setValue(specname);
                this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                Process proc = cl.execute();
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while ((line = br.readLine()) != null) {
                    this.getLogger().debug("Consuming: " + line);
                    consumer.consumeLine(line);
                }
                br.close();
                BufferedReader brErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                while ((line = brErr.readLine()) != null) {
                    this.getLogger().debug("Consuming stderr: " + line);
                    consumer.consumeLine(line);
                }
                brErr.close();
            }
            catch (CommandLineException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        } else if (clientspecExists) {
            System.setProperty("maven.scm.perforce.clientspec.name", specname);
        }
        return checkOutScmResult;
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmVersion version, String specname) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("-c" + specname);
        command.createArgument().setValue("sync");
        String[] files = workingDirectory.list();
        if (files == null || files.length == 0) {
            command.createArgument().setValue("-f");
        }
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            command.createArgument().setValue("@" + version.getName());
        }
        return command;
    }
}

