/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.diff;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.diff.AbstractDiffCommand;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.diff.PerforceDiffConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceDiffCommand
extends AbstractDiffCommand
implements PerforceCommand {
    protected DiffScmResult executeDiffCommand(ScmProviderRepository repo, ScmFileSet files, ScmVersion startRev, ScmVersion endRev) throws ScmException {
        Commandline cl = PerforceDiffCommand.createCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), startRev, endRev);
        PerforceDiffConsumer consumer = new PerforceDiffConsumer();
        boolean success = false;
        try {
            String line;
            Process proc = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                consumer.consumeLine(line);
            }
            success = proc.waitFor() == 0;
        }
        catch (CommandLineException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return new DiffScmResult(cl.toString(), success ? "Diff successful" : "Unable to diff", consumer.getOutput(), success);
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmVersion startRev, ScmVersion endRev) {
        String start = startRev != null && StringUtils.isNotEmpty((String)startRev.getName()) ? "@" + startRev.getName() : "";
        String end = endRev != null && StringUtils.isNotEmpty((String)endRev.getName()) ? endRev.getName() : "head";
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("diff2");
        command.createArgument().setValue("-u");
        command.createArgument().setValue("..." + start);
        command.createArgument().setValue("...@" + end);
        return command;
    }
}

