/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.untag;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmUntagParameters;
import org.apache.maven.scm.command.untag.AbstractUntagCommand;
import org.apache.maven.scm.command.untag.UntagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnUntagCommand
extends AbstractUntagCommand
implements SvnCommand {
    private final boolean interactive;

    public SvnUntagCommand(boolean interactive) {
        this.interactive = interactive;
    }

    public ScmResult executeUntagCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmUntagParameters scmUntagParameters) throws ScmException {
        int exitCode;
        String tag = scmUntagParameters.getTag();
        if (tag == null || tag.trim().isEmpty()) {
            throw new ScmException("tag must be specified");
        }
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        String message = scmUntagParameters.getMessage();
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)"UTF-8", (String)message);
        }
        catch (IOException ex) {
            return new UntagScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        Commandline cl = this.createCommandline(repository, fileSet, tag, messageFile);
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            if (Os.isFamily((String)"windows")) {
                this.logger.debug("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
            }
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, stdout, stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing svn remove command.", (Throwable)ex);
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException iOException) {}
        }
        if (exitCode == 0) {
            return new UntagScmResult(cl.toString(), "The svn remove command was successful.", stderr.getOutput(), true);
        }
        return new UntagScmResult(cl.toString(), "The svn remove command failed.", stderr.getOutput(), false);
    }

    Commandline createCommandline(SvnScmProviderRepository repo, ScmFileSet fileSet, String tag, File messageFile) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(fileSet.getBasedir(), repo, this.interactive);
        cl.createArg().setValue("--file");
        cl.createArg().setValue(messageFile.getAbsolutePath());
        cl.createArg().setValue("remove");
        String tagUrl = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repo, (ScmTag)new ScmTag(tag));
        tagUrl = SvnCommandUtils.fixUrl((String)tagUrl, (String)repo.getUser());
        cl.createArg().setValue(tagUrl + "@");
        return cl;
    }
}

