/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.ReporterConfiguration;

class ForkTimeout {
    private final Timer timer;

    ForkTimeout(int timeOutInMs, ReporterConfiguration reporterConfiguration, SurefireProvider surefireProvider) {
        SurefireTimeoutMonitor timeoutTask = new SurefireTimeoutMonitor(reporterConfiguration, surefireProvider);
        this.timer = new Timer("Surefire fork timeout timer");
        this.timer.schedule((TimerTask)timeoutTask, timeOutInMs);
    }

    public void close() {
        this.timer.cancel();
    }

    private static class SurefireTimeoutMonitor
    extends TimerTask {
        private final ReporterConfiguration reporterConfiguration;
        private final SurefireProvider surefireProvider;

        public SurefireTimeoutMonitor(ReporterConfiguration reporterConfiguration, SurefireProvider surefireProvider) {
            this.reporterConfiguration = reporterConfiguration;
            this.surefireProvider = surefireProvider;
        }

        public void run() {
            this.reporterConfiguration.setTimedOut(true);
            this.surefireProvider.cancel();
        }
    }
}

