/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter.spi;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.api.booter.Command;
import org.apache.maven.surefire.api.booter.DumpErrorSingleton;
import org.apache.maven.surefire.api.booter.MasterProcessChannelDecoder;
import org.apache.maven.surefire.api.booter.MasterProcessCommand;
import org.apache.maven.surefire.api.util.internal.ImmutableMap;

public class LegacyMasterProcessChannelDecoder
implements MasterProcessChannelDecoder {
    private static final Map<String, MasterProcessCommand> COMMAND_OPCODES = LegacyMasterProcessChannelDecoder.stringsToOpcodes();
    private final ReadableByteChannel channel;

    public LegacyMasterProcessChannelDecoder(@Nonnull ReadableByteChannel channel) {
        this.channel = channel;
    }

    @Nonnull
    public Command decode() throws IOException {
        ArrayList<String> tokens = new ArrayList<String>(3);
        StringBuilder token = new StringBuilder("maven-surefire-command".length());
        ByteBuffer buffer = ByteBuffer.allocate(1);
        block0: while (true) {
            boolean endOfStream;
            tokens.clear();
            token.setLength(0);
            FrameCompletion completion = null;
            boolean frameStarted = false;
            while (!(endOfStream = this.channel.read(buffer) == -1)) {
                buffer.flip();
                char c = (char)buffer.get();
                buffer.clear();
                if (!frameStarted) {
                    if (c == ':') {
                        frameStarted = true;
                        token.setLength(0);
                        tokens.clear();
                    }
                } else if (c == ':') {
                    tokens.add(token.toString());
                    token.setLength(0);
                    completion = LegacyMasterProcessChannelDecoder.frameCompleteness(tokens);
                    if (completion == FrameCompletion.COMPLETE) break;
                    if (completion == FrameCompletion.MALFORMED) {
                        DumpErrorSingleton.getSingleton().dumpStreamText("Malformed frame with tokens " + tokens);
                        continue block0;
                    }
                } else {
                    token.append(c);
                }
                completion = null;
            }
            if (completion == FrameCompletion.COMPLETE) {
                MasterProcessCommand cmd = COMMAND_OPCODES.get(tokens.get(1));
                if (tokens.size() == 2) {
                    return new Command(cmd);
                }
                if (tokens.size() == 3) {
                    return new Command(cmd, (String)tokens.get(2));
                }
            }
            if (endOfStream) break;
        }
        throw new EOFException();
    }

    private static FrameCompletion frameCompleteness(List<String> tokens) {
        if (!tokens.isEmpty() && !"maven-surefire-command".equals(tokens.get(0))) {
            return FrameCompletion.MALFORMED;
        }
        if (tokens.size() >= 2) {
            String opcode = tokens.get(1);
            MasterProcessCommand cmd = COMMAND_OPCODES.get(opcode);
            if (cmd == null) {
                return FrameCompletion.MALFORMED;
            }
            if (cmd.hasDataType() == (tokens.size() == 3)) {
                return FrameCompletion.COMPLETE;
            }
        }
        return FrameCompletion.NOT_COMPLETE;
    }

    public void close() {
    }

    private static Map<String, MasterProcessCommand> stringsToOpcodes() {
        HashMap<String, MasterProcessCommand> opcodes = new HashMap<String, MasterProcessCommand>();
        opcodes.put("run-testclass", MasterProcessCommand.RUN_CLASS);
        opcodes.put("testset-finished", MasterProcessCommand.TEST_SET_FINISHED);
        opcodes.put("skip-since-next-test", MasterProcessCommand.SKIP_SINCE_NEXT_TEST);
        opcodes.put("shutdown", MasterProcessCommand.SHUTDOWN);
        opcodes.put("noop", MasterProcessCommand.NOOP);
        opcodes.put("bye-ack", MasterProcessCommand.BYE_ACK);
        return new ImmutableMap(opcodes);
    }

    private static enum FrameCompletion {
        NOT_COMPLETE,
        COMPLETE,
        MALFORMED;

    }
}

