/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Map;
import org.apache.maven.surefire.junitcore.ConcurrentReporterManager;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.testset.TestSetFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodsParallelRunListener
extends ConcurrentReporterManager {
    private volatile TestSet lastStarted;
    private final Object lock = new Object();

    public MethodsParallelRunListener(Map<String, TestSet> classMethodCounts, ReporterFactory reporterFactory, ReporterConfiguration reporterConfiguration, boolean reportImmediately) throws TestSetFailedException {
        super(reporterFactory, reportImmediately, reporterConfiguration, classMethodCounts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIfTestSetCanBeReported(TestSet testSetForTest) {
        Object object = this.lock;
        synchronized (object) {
            if (testSetForTest != this.lastStarted) {
                if (this.lastStarted != null) {
                    this.lastStarted.setAllScheduled(this.getReporterManager());
                }
                this.lastStarted = testSetForTest;
            }
        }
    }
}

