/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import org.apache.maven.surefire.junitcore.LogicalStream;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReportWriter;

class TestMethod {
    private final ReportEntry description;
    private final long startTime;
    private long endTime;
    private volatile ReportEntry testFailure;
    private volatile ReportEntry testError;
    private volatile ReportEntry ignored;
    private static final InheritableThreadLocal<TestMethod> TEST_METHOD = new InheritableThreadLocal();
    private volatile LogicalStream output;

    public TestMethod(ReportEntry description) {
        this.description = description;
        this.startTime = System.currentTimeMillis();
    }

    public void testFinished() {
        this.setEndTime();
    }

    public void testIgnored(ReportEntry description) {
        this.ignored = description;
        this.setEndTime();
    }

    public void testFailure(ReportEntry failure) {
        this.testFailure = failure;
    }

    public void testError(ReportEntry failure) {
        this.testError = failure;
        this.setEndTime();
    }

    private void setEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    public int getElapsed() {
        return (int)(this.endTime - this.startTime);
    }

    public void replay(ReportWriter reporter) throws Exception {
        if (this.ignored != null) {
            reporter.testSkipped(this.createReportEntry());
            return;
        }
        reporter.testStarting(this.createReportEntry());
        if (this.output != null) {
            this.output.writeDetails(reporter);
        }
        if (this.testFailure != null) {
            reporter.testFailed(this.testFailure, this.getStdout(), this.getStdErr());
        } else if (this.testError != null) {
            reporter.testError(this.testError, this.getStdout(), this.getStdErr());
        } else {
            reporter.testSucceeded(this.createReportEntry());
        }
    }

    private ReportEntry createReportEntry() {
        return this.description;
    }

    public void attachToThread() {
        TEST_METHOD.set(this);
    }

    public static void detachFromCurrentThread() {
        TEST_METHOD.remove();
    }

    public static TestMethod getThreadTestMethod() {
        return (TestMethod)TEST_METHOD.get();
    }

    public LogicalStream getLogicalStream() {
        if (this.output == null) {
            this.output = new LogicalStream();
        }
        return this.output;
    }

    private String getStdout() {
        return this.output != null ? this.output.getOutput(true) : "";
    }

    private String getStdErr() {
        return this.output != null ? this.output.getOutput(false) : "";
    }
}

