/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.surefire.NonAbstractClassFilter;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.testng.TestNGExecutor;
import org.apache.maven.surefire.testng.TestNGTestSet;
import org.apache.maven.surefire.testng.TestNGXmlTestSuite;
import org.apache.maven.surefire.testng.TestNgTestSuite;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;

public class TestNGDirectoryTestSuite
implements TestNgTestSuite {
    private final Map options;
    private final Map junitOptions;
    private final String testSourceDirectory;
    private final File reportsDirectory;
    private SortedMap<String, TestNGTestSet> testSets;
    private final ScanResult scanResult;
    private final String testMethodPattern;
    private final RunOrderCalculator runOrderCalculator;
    private final Class junitTestClass;
    private Class<? extends Annotation> junitRunWithAnnotation;
    private Class<? extends Annotation> junitTestAnnotation;

    public TestNGDirectoryTestSuite(String testSourceDirectory, Properties confOptions, File reportsDirectory, String testMethodPattern, RunOrderCalculator runOrderCalculator, ScanResult scanResult) {
        this.runOrderCalculator = runOrderCalculator;
        this.options = confOptions;
        this.testSourceDirectory = testSourceDirectory;
        this.reportsDirectory = reportsDirectory;
        this.scanResult = scanResult;
        this.testMethodPattern = testMethodPattern;
        this.junitTestClass = this.findJUnitTestClass();
        this.junitRunWithAnnotation = this.findJUnitRunWithAnnotation();
        this.junitTestAnnotation = this.findJUnitTestAnnotation();
        this.junitOptions = this.createJUnitOptions();
    }

    public void execute(TestsToRun testsToRun, ReporterFactory reporterManagerFactory) throws ReporterException, TestSetFailedException {
        if (!testsToRun.allowEagerReading()) {
            this.executeLazy(testsToRun, reporterManagerFactory);
        } else if (testsToRun.containsAtLeast(2)) {
            this.executeMulti(testsToRun, reporterManagerFactory);
        } else if (testsToRun.containsAtLeast(1)) {
            Class testClass = (Class)testsToRun.iterator().next();
            this.executeSingleClass(reporterManagerFactory, testClass);
        }
    }

    private void executeSingleClass(ReporterFactory reporterManagerFactory, Class testClass) throws TestSetFailedException {
        this.options.put("suitename", testClass.getName());
        RunListener reporter = reporterManagerFactory.createReporter();
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
        TestNGDirectoryTestSuite.startTestSuite(reporter, this);
        Map optionsToUse = this.isJUnitTest(testClass) ? this.junitOptions : this.options;
        TestNGExecutor.run(new Class[]{testClass}, this.testSourceDirectory, optionsToUse, reporter, this, this.reportsDirectory, this.testMethodPattern);
        TestNGDirectoryTestSuite.finishTestSuite(reporter, this);
    }

    public void executeLazy(TestsToRun testsToRun, ReporterFactory reporterFactory) throws ReporterException, TestSetFailedException {
        for (Class c : testsToRun) {
            this.executeSingleClass(reporterFactory, c);
        }
    }

    private Class findJUnitTestClass() {
        return this.lookupClass("junit.framework.Test");
    }

    private Class findJUnitRunWithAnnotation() {
        return this.lookupClass("org.junit.runner.RunWith");
    }

    private Class findJUnitTestAnnotation() {
        return this.lookupClass("org.junit.Test");
    }

    private Class lookupClass(String className) {
        Class<?> junitClass;
        try {
            junitClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            junitClass = null;
        }
        return junitClass;
    }

    public void executeMulti(TestsToRun testsToRun, ReporterFactory reporterFactory) throws ReporterException, TestSetFailedException {
        ArrayList<Class> testNgTestClasses = new ArrayList<Class>();
        ArrayList<Class> junitTestClasses = new ArrayList<Class>();
        for (Class c : testsToRun) {
            if (this.isJUnitTest(c)) {
                junitTestClasses.add(c);
                continue;
            }
            testNgTestClasses.add(c);
        }
        File testNgReportsDirectory = this.reportsDirectory;
        File junitReportsDirectory = this.reportsDirectory;
        if (junitTestClasses.size() > 0 && testNgTestClasses.size() > 0) {
            testNgReportsDirectory = new File(this.reportsDirectory, "testng-native-results");
            junitReportsDirectory = new File(this.reportsDirectory, "testng-junit-results");
        }
        RunListener reporterManager = reporterFactory.createReporter();
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporterManager));
        TestNGDirectoryTestSuite.startTestSuite(reporterManager, this);
        Class[] testClasses = testNgTestClasses.toArray(new Class[testNgTestClasses.size()]);
        TestNGExecutor.run(testClasses, this.testSourceDirectory, this.options, reporterManager, this, testNgReportsDirectory, this.testMethodPattern);
        if (junitTestClasses.size() > 0) {
            testClasses = junitTestClasses.toArray(new Class[junitTestClasses.size()]);
            TestNGExecutor.run(testClasses, this.testSourceDirectory, this.junitOptions, reporterManager, this, junitReportsDirectory, this.testMethodPattern);
        }
        TestNGDirectoryTestSuite.finishTestSuite(reporterManager, this);
    }

    private boolean isJUnitTest(Class c) {
        return this.isJunit3Test(c) || this.isJunit4Test(c);
    }

    private boolean isJunit4Test(Class c) {
        return this.hasJunit4RunWithAnnotation(c) || this.hasJunit4TestAnnotation(c);
    }

    private boolean hasJunit4RunWithAnnotation(Class c) {
        return this.junitRunWithAnnotation != null && c.getAnnotation(this.junitRunWithAnnotation) != null;
    }

    private boolean hasJunit4TestAnnotation(Class c) {
        if (this.junitTestAnnotation != null) {
            for (Method m : c.getMethods()) {
                if (m.getAnnotation(this.junitTestAnnotation) == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isJunit3Test(Class c) {
        return this.junitTestClass != null && this.junitTestClass.isAssignableFrom(c);
    }

    private Map createJUnitOptions() {
        HashMap<String, Boolean> junitOptions = new HashMap<String, Boolean>(this.options);
        junitOptions.put("junit", Boolean.TRUE);
        return junitOptions;
    }

    public void execute(String testSetName, ReporterFactory reporterManagerFactory) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        TestNGTestSet testSet = (TestNGTestSet)this.testSets.get(testSetName);
        if (testSet == null) {
            throw new TestSetFailedException("Unable to find test set '" + testSetName + "' in suite");
        }
        RunListener reporter = reporterManagerFactory.createReporter();
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
        TestNGDirectoryTestSuite.startTestSuite(reporter, this);
        TestNGExecutor.run(new Class[]{testSet.getTestClass()}, this.testSourceDirectory, this.options, reporter, this, this.reportsDirectory, this.testMethodPattern);
        TestNGDirectoryTestSuite.finishTestSuite(reporter, this);
    }

    public static void startTestSuite(RunListener reporter, Object suite) {
        SimpleReportEntry report = new SimpleReportEntry(suite.getClass().getName(), TestNGDirectoryTestSuite.getSuiteName(suite));
        try {
            reporter.testSetStarting((ReportEntry)report);
        }
        catch (ReporterException reporterException) {
            // empty catch block
        }
    }

    public static void finishTestSuite(RunListener reporterManager, Object suite) throws ReporterException {
        SimpleReportEntry report = new SimpleReportEntry(suite.getClass().getName(), TestNGDirectoryTestSuite.getSuiteName(suite));
        reporterManager.testSetCompleted((ReportEntry)report);
    }

    public String getSuiteName() {
        String result = (String)this.options.get("suitename");
        if (result == null) {
            result = "TestSuite";
        }
        return result;
    }

    private static String getSuiteName(Object suite) {
        if (suite instanceof TestNGDirectoryTestSuite) {
            return ((TestNGDirectoryTestSuite)suite).getSuiteName();
        }
        if (suite instanceof TestNGXmlTestSuite) {
            return ((TestNGXmlTestSuite)suite).getSuiteName();
        }
        String result = "TestSuite";
        return result;
    }

    public Map locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        if (this.testSets != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        this.testSets = new TreeMap<String, TestNGTestSet>();
        TestsToRun scanned = this.scanResult.applyFilter((ScannerFilter)new NonAbstractClassFilter(), classLoader);
        TestsToRun testsToRun = this.runOrderCalculator.orderTestClasses(scanned);
        for (Class testClass : testsToRun) {
            TestNGTestSet testSet = new TestNGTestSet(testClass);
            if (this.testSets.containsKey(testSet.getName())) {
                throw new TestSetFailedException("Duplicate test set '" + testSet.getName() + "'");
            }
            this.testSets.put(testSet.getName(), testSet);
        }
        return Collections.unmodifiableSortedMap(this.testSets);
    }
}

