/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="bundle", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class MeecrowaveBundleMojo
extends AbstractMojo {
    private static final String DELETE_TEXT = "Just there to not loose the folder cause it is empty, you can safely delete.";
    @Parameter(property="meecrowave.main", defaultValue="org.apache.meecrowave.runner.Cli")
    private String main;
    @Parameter(property="meecrowave.scopes", defaultValue="compile,runtime")
    private Collection<String> scopes;
    @Parameter(property="meecrowave.bin", defaultValue="src/main/meecrowave/bin")
    private String bin;
    @Parameter(property="meecrowave.conf", defaultValue="src/main/meecrowave/conf")
    private String conf;
    @Parameter(property="meecrowave.libs")
    private Collection<String> libs;
    @Parameter(property="meecrowave.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="meecrowave.formats", defaultValue="zip")
    private Collection<String> formats;
    @Parameter(property="meecrowave.classifier")
    private String classifier;
    @Parameter(property="meecrowave.attach", defaultValue="true")
    private boolean attach;
    @Parameter(property="meecrowave.no-root", defaultValue="false")
    private boolean skipArchiveRootFolder;
    @Parameter(property="meecrowave.keep-exploded-folder", defaultValue="false")
    private boolean keepExplodedFolder;
    @Parameter(property="meecrowave.root-name")
    private String rootName;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File buildDirectory;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    private String artifactId;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}", readonly=true)
    private File app;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="meecrowave.enforce-commons_cli", defaultValue="true")
    private boolean enforceCommonsCli;
    @Parameter(property="meecrowave.enforce-meecrowave", defaultValue="true")
    private boolean enforceMeecrowave;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private ArtifactResolver resolver;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ProjectDependenciesResolver dependenciesResolver;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    private List<RemoteRepository> remoteRepositories;

    /*
     * Unable to fully structure code
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().warn((CharSequence)(this.getClass().getSimpleName() + " skipped"));
            return;
        }
        distroFolder = new File(this.buildDirectory, this.rootName == null ? this.artifactId + "-distribution" : this.rootName);
        if (distroFolder.exists()) {
            this.delete(distroFolder);
        }
        Stream.of(new String[]{"bin", "conf", "logs", "lib"}).forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$0(java.io.File java.lang.String ), (Ljava/lang/String;)V)((File)distroFolder));
        try {
            reader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("bin/meecrowave.sh")));
            var3_4 = null;
            try {
                this.write(new File(distroFolder, "bin/meecrowave.sh"), StrSubstitutor.replace((Object)reader.lines().collect(Collectors.joining("\n")), (Map)new HashMap<String, String>(){
                    {
                        this.put("main", MeecrowaveBundleMojo.this.main);
                    }
                }));
            }
            catch (Throwable var4_6) {
                var3_4 = var4_6;
                throw var4_6;
            }
            finally {
                if (reader != null) {
                    if (var3_4 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable var4_5) {
                            var3_4.addSuppressed(var4_5);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.copyProvidedFiles(distroFolder);
        this.write(new File(distroFolder, "logs/you_can_safely_delete.txt"), "Just there to not loose the folder cause it is empty, you can safely delete.");
        includedArtifacts = this.project.getArtifacts().stream().filter((Predicate<Artifact>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isIncluded(org.apache.maven.artifact.Artifact ), (Lorg/apache/maven/artifact/Artifact;)Z)((MeecrowaveBundleMojo)this)).map((Function<Artifact, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$execute$1(java.io.File org.apache.maven.artifact.Artifact ), (Lorg/apache/maven/artifact/Artifact;)Ljava/lang/String;)((MeecrowaveBundleMojo)this, (File)distroFolder)).collect(Collectors.toList());
        if (this.app.exists()) {
            this.addLib(distroFolder, this.app);
        }
        if (this.enforceCommonsCli && !includedArtifacts.contains("commons-cli")) {
            this.addLib(distroFolder, this.resolve("commons-cli", "commons-cli", "1.3.1", ""));
        }
        if (this.libs != null) {
            this.libs.forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$2(java.io.File java.lang.String ), (Ljava/lang/String;)V)((MeecrowaveBundleMojo)this, (File)distroFolder));
        }
        if (this.enforceMeecrowave && !includedArtifacts.contains("meecrowave-core")) {
            request = new DefaultDependencyResolutionRequest();
            request.setMavenProject(new MavenProject(){
                {
                    this.getDependencies().add(new Dependency(){
                        {
                            this.setGroupId("org.apache.meecrowave");
                            this.setArtifactId("meecrowave-core");
                            this.setVersion(MeecrowaveBundleMojo.this.findVersion());
                        }
                    });
                }
            });
            request.setRepositorySession(this.session);
            try {
                this.dependenciesResolver.resolve((DependencyResolutionRequest)request).getDependencyGraph().accept(new DependencyVisitor(){

                    public boolean visitEnter(DependencyNode node) {
                        return true;
                    }

                    public boolean visitLeave(DependencyNode node) {
                        org.eclipse.aether.artifact.Artifact artifact = node.getArtifact();
                        if (artifact != null && !includedArtifacts.contains(artifact.getArtifactId())) {
                            MeecrowaveBundleMojo.this.addLib(distroFolder, artifact.getFile());
                        }
                        return true;
                    }
                });
            }
            catch (DependencyResolutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        prefix = this.skipArchiveRootFolder != false ? distroFolder.toPath() : distroFolder.getParentFile().toPath();
        for (String format : this.formats) {
            this.getLog().info((CharSequence)(format + "-ing Custom Meecrowave Distribution"));
            output = new File(this.buildDirectory, this.artifactId + "-meecrowave-distribution." + format);
            var7_13 = format.toLowerCase(Locale.ENGLISH);
            var8_14 = -1;
            switch (var7_13.hashCode()) {
                case -880960548: {
                    if (!var7_13.equals("tar.gz")) break;
                    var8_14 = 0;
                    break;
                }
                case 120609: {
                    if (!var7_13.equals("zip")) break;
                    var8_14 = 1;
                }
            }
            switch (var8_14) {
                case 0: {
                    try {
                        tarGz = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(output)));
                        var10_18 = null;
                        tarGz.setLongFileMode(2);
                        for (String entry : distroFolder.list()) {
                            this.tarGz(tarGz, new File(distroFolder, entry), prefix);
                        }
                        if (tarGz == null) break;
                        if (var10_18 == null) ** GOTO lbl84
                        try {
                            tarGz.close();
                        }
                        catch (Throwable var11_20) {
                            var10_18.addSuppressed(var11_20);
                        }
                        break;
lbl84:
                        // 1 sources

                        tarGz.close();
                        ** break;
                        catch (Throwable var11_21) {
                            try {
                                var10_18 = var11_21;
                                throw var11_21;
                            }
                            catch (Throwable var15_27) {
                                if (tarGz != null) {
                                    if (var10_18 != null) {
                                        try {
                                            tarGz.close();
                                        }
                                        catch (Throwable var16_28) {
                                            var10_18.addSuppressed(var16_28);
                                        }
                                    } else {
                                        tarGz.close();
                                    }
                                }
                                throw var15_27;
lbl101:
                                // 1 sources

                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                }
                case 1: {
                    try {
                        zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(output));
                        var10_18 = null;
                        for (String entry : distroFolder.list()) {
                            this.zip(zos, new File(distroFolder, entry), prefix);
                        }
                        if (zos == null) break;
                        if (var10_18 == null) ** GOTO lbl120
                        try {
                            zos.close();
                        }
                        catch (Throwable var11_22) {
                            var10_18.addSuppressed(var11_22);
                        }
                        break;
lbl120:
                        // 1 sources

                        zos.close();
                        ** break;
                        catch (Throwable var11_23) {
                            try {
                                var10_18 = var11_23;
                                throw var11_23;
                            }
                            catch (Throwable var17_29) {
                                if (zos != null) {
                                    if (var10_18 != null) {
                                        try {
                                            zos.close();
                                        }
                                        catch (Throwable var18_30) {
                                            var10_18.addSuppressed(var18_30);
                                        }
                                    } else {
                                        zos.close();
                                    }
                                }
                                throw var17_29;
lbl137:
                                // 1 sources

                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                }
                default: {
                    throw new IllegalArgumentException(format + " is not supported");
                }
            }
            this.attach(format, output);
        }
        if (!this.keepExplodedFolder) {
            this.delete(distroFolder);
        }
    }

    private void copyProvidedFiles(File distroFolder) throws MojoExecutionException {
        File srcBin;
        boolean customLog4jConfig = false;
        boolean customMwProperties = false;
        Log log = this.getLog();
        File srcConf = new File(this.project.getBasedir(), this.conf);
        if (srcConf.exists() && srcConf.isDirectory()) {
            File targetConf = new File(distroFolder, "conf");
            targetConf.mkdirs();
            for (File file : srcConf.listFiles()) {
                String fileName = file.getName();
                if ("log4j2.xml".equals(fileName)) {
                    customLog4jConfig = true;
                }
                if ("meecrowave.properties".equals(fileName)) {
                    customMwProperties = true;
                }
                if (fileName.startsWith(".")) continue;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Copying file from " + file + " to " + targetConf));
                    }
                    Files.copy(file.toPath(), new File(targetConf, fileName).toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy file " + file.getAbsolutePath(), (Exception)e);
                }
            }
        }
        if (!customLog4jConfig) {
            this.writeLog4jConfig(distroFolder);
        }
        if (!customMwProperties) {
            this.writeMeecrowaveProperties(distroFolder);
        }
        if ((srcBin = new File(this.project.getBasedir(), this.bin)).exists() && srcBin.isDirectory()) {
            File targetRoot = new File(distroFolder, "bin");
            targetRoot.mkdirs();
            Stream.of(srcBin.listFiles()).filter(f -> !f.isDirectory()).forEach(f -> {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Copying file from " + f + " to " + targetRoot));
                    }
                    File target = new File(targetRoot, f.getName());
                    Files.copy(f.toPath(), target.toPath(), new CopyOption[0]);
                    if (target.getName().endsWith(".sh")) {
                        target.setExecutable(true);
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not copy file " + f.getAbsolutePath(), e);
                }
            });
        }
    }

    private void writeMeecrowaveProperties(File distroFolder) {
        this.write(new File(distroFolder, "conf/meecrowave.properties"), "# This file contains the meecrowave default configuration\n# More on http://openwebbeans.apache.org/meecrowave/meecrowave-core/cli.html\n\ntomcat-access-log-pattern = %h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"");
    }

    private void writeLog4jConfig(File distroFolder) {
        this.write(new File(distroFolder, "conf/log4j2.xml"), "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Configuration status=\"INFO\">\n  <Properties>\n    <Property name=\"name\">" + this.artifactId + "</Property>\n  </Properties>\n  <Appenders>\n    <Console name=\"Console\" target=\"SYSTEM_OUT\">\n      <PatternLayout pattern=\"[%d{HH:mm:ss.SSS}][%highlight{%-5level}][%15.15t][%30.30logger] %msg%n\"/>\n    </Console>\n    <RollingFile name=\"DailyLogFile\" fileName=\"${sys:meecrowave.base}/logs/meecrowave.log\"\n                 filePattern=\"${sys:meecrowave.base}/logs/${name}-%d{yyyy-MM-dd}-%i.log.gz\">\n      <PatternLayout pattern=\"[%d{HH:mm:ss.SSS}][%-5level][%15.15t][%30.30logger] %msg%n\"/>\n      <Policies>\n        <TimeBasedTriggeringPolicy />\n        <SizeBasedTriggeringPolicy size=\"50 MB\"/>\n      </Policies>\n    </RollingFile>\n  </Appenders>\n  <Loggers>\n    <Root level=\"INFO\">\n      <!--<AppenderRef ref=\"Console\"/>-->\n      <AppenderRef ref=\"DailyLogFile\"/>\n    </Root>\n  </Loggers>\n</Configuration>\n\n");
    }

    private void addLib(File distroFolder, File cc) {
        try {
            Files.copy(cc.toPath(), new File(distroFolder, "lib/" + cc.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private String findVersion() {
        return new Properties(){
            {
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/maven/org.apache.meecrowave/meecrowave-core/pom.properties");){
                    if (is != null) {
                        this.load(is);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }.getProperty("version", "0.3.2");
    }

    private File resolve(String group, String artifact, String version, String classifier) {
        DefaultArtifact art = new DefaultArtifact(group, artifact, classifier, "jar", version);
        ArtifactRequest artifactRequest = new ArtifactRequest().setArtifact((org.eclipse.aether.artifact.Artifact)art).setRepositories(this.remoteRepositories);
        LocalRepositoryManager lrm = this.session.getLocalRepositoryManager();
        art.setFile(new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalArtifact(artifactRequest.getArtifact())));
        try {
            ArtifactResult result = this.repositorySystem.resolveArtifact(this.session, artifactRequest);
            if (result.isMissing()) {
                throw new IllegalStateException("Can't find commons-cli, please add it to the pom.");
            }
            return result.getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private boolean isIncluded(Artifact a) {
        return !(this.scopes == null && !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope()) || this.scopes != null && !this.scopes.contains(a.getScope()));
    }

    private void write(File file, String content) {
        try {
            Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void delete(File distroFolder) {
        Path rootPath = distroFolder.toPath();
        try {
            Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.getLog().warn((Throwable)e);
        }
    }

    private void attach(String ext, File output) {
        if (this.attach) {
            this.getLog().info((CharSequence)("Attaching Custom Meecrowave Distribution (" + ext + ")"));
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.project, ext, this.classifier, output);
            } else {
                this.projectHelper.attachArtifact(this.project, ext, output);
            }
        }
    }

    private void zip(ZipArchiveOutputStream zip, File f, Path prefix) throws IOException {
        String path = prefix.relativize(f.toPath()).toString().replace(File.separator, "/");
        ZipArchiveEntry archiveEntry = new ZipArchiveEntry(f, path);
        if (this.isSh(path)) {
            archiveEntry.setUnixMode(493);
        }
        zip.putArchiveEntry((ArchiveEntry)archiveEntry);
        if (f.isDirectory()) {
            zip.closeArchiveEntry();
            File[] files = f.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.zip(zip, child, prefix);
                }
            }
        } else {
            Files.copy(f.toPath(), (OutputStream)zip);
            zip.closeArchiveEntry();
        }
    }

    private void tarGz(TarArchiveOutputStream tarGz, File f, Path prefix) throws IOException {
        String path = prefix.relativize(f.toPath()).toString().replace(File.separator, "/");
        TarArchiveEntry archiveEntry = new TarArchiveEntry(f, path);
        if (this.isSh(path)) {
            archiveEntry.setMode(493);
        }
        tarGz.putArchiveEntry((ArchiveEntry)archiveEntry);
        if (f.isDirectory()) {
            tarGz.closeArchiveEntry();
            File[] files = f.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.tarGz(tarGz, child, prefix);
                }
            }
        } else {
            Files.copy(f.toPath(), (OutputStream)tarGz);
            tarGz.closeArchiveEntry();
        }
    }

    private boolean isSh(String path) {
        return path.endsWith(".sh");
    }

    private /* synthetic */ void lambda$execute$2(File distroFolder, String l) {
        String[] c = l.split(":");
        if (c.length != 3 && c.length != 4) {
            throw new IllegalArgumentException("libs syntax is groupId:artifactId:version[:classifier]");
        }
        this.addLib(distroFolder, this.resolve(c[0], c[1], c[2], c.length == 4 ? c[3] : ""));
    }

    private /* synthetic */ String lambda$execute$1(File distroFolder, Artifact a) {
        this.addLib(distroFolder, a.getFile());
        return a.getArtifactId();
    }

    private static /* synthetic */ void lambda$execute$0(File distroFolder, String i) {
        new File(distroFolder, i).mkdirs();
    }
}

