/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.schedule.AbstractScheduleRenderer;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;

public abstract class AbstractCompactScheduleRenderer
extends AbstractScheduleRenderer
implements Serializable {
    private static final Log log = LogFactory.getLog(AbstractCompactScheduleRenderer.class);

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    protected abstract int getDefaultRowHeight();

    protected void writeDayCell(FacesContext context, ResponseWriter writer, HtmlSchedule schedule, ScheduleDay day, float cellWidth, int dayOfWeek, int dayOfMonth, boolean isWeekend, boolean isCurrentMonth, int rowspan) throws IOException {
        String clientId = schedule.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)schedule, context);
        String formId = parentFormInfo == null ? null : parentFormInfo.getFormName();
        String dayHeaderId = clientId + "_header_" + ScheduleUtil.getDateId(day.getDate(), schedule.getModel().getTimeZone());
        String dayBodyId = clientId + "_body_" + ScheduleUtil.getDateId(day.getDate(), schedule.getModel().getTimeZone());
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("rowspan", (Object)String.valueOf(rowspan), null);
        boolean isToday = ScheduleUtil.isSameDay(day.getDate(), new Date(), schedule.getModel().getTimeZone());
        String dayClass = this.getStyleClass((UIComponent)schedule, isCurrentMonth ? "day" : "inactive-day") + " " + this.getStyleClass((UIComponent)schedule, isWeekend ? "weekend" : "workday") + " " + (isToday ? this.getStyleClass((UIComponent)schedule, "today") : "");
        writer.writeAttribute("class", (Object)dayClass, null);
        StringBuffer styleBuffer = new StringBuffer();
        int rowHeight = this.getRowHeight(schedule);
        String myRowHeight = "height: ";
        String myContentHeight = "height: ";
        if (rowHeight > 0) {
            if (isWeekend && schedule.isSplitWeekend()) {
                myRowHeight = myRowHeight + rowHeight / 2 + "px;";
                myContentHeight = myContentHeight + (rowHeight / 2 - 19) + "px;";
            } else {
                myRowHeight = myRowHeight + (rowHeight + (schedule.isSplitWeekend() ? 1 : 0)) + "px;";
                myContentHeight = myContentHeight + (rowHeight + (schedule.isSplitWeekend() ? 1 : 0) - 18) + "px;";
            }
        } else {
            myRowHeight = myRowHeight + "100%;";
            myContentHeight = myContentHeight + "100%;";
        }
        styleBuffer.append(myRowHeight);
        styleBuffer.append("width: " + cellWidth + "%;");
        styleBuffer.append("vertical-align: top;");
        writer.writeAttribute("style", (Object)styleBuffer.toString(), null);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "day"), null);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "header"), null);
        writer.writeAttribute("style", (Object)"height: 18px; overflow: hidden", null);
        writer.startElement("a", (UIComponent)schedule);
        writer.writeAttribute("id", (Object)dayHeaderId, null);
        writer.writeAttribute("href", (Object)"#", null);
        if (!schedule.isReadonly() && schedule.isSubmitOnClick()) {
            writer.writeAttribute("onclick", (Object)("fireScheduleDateClicked(this, event, '" + formId + "', '" + clientId + "');"), null);
        }
        writer.writeText((Object)this.getDateString(context, schedule, day.getDate()), null);
        writer.endElement("a");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "content"), null);
        writer.writeAttribute("style", (Object)(myContentHeight + " overflow: auto; vertical-align: top;"), null);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"height: 100%; vertical-align: top;", null);
        writer.writeAttribute("id", (Object)dayBodyId, null);
        if (!schedule.isReadonly() && schedule.isSubmitOnClick()) {
            writer.writeAttribute("onclick", (Object)("fireScheduleTimeClicked(this, event, '" + formId + "', '" + clientId + "');"), null);
        }
        this.writeEntries(context, schedule, day, writer);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("td");
    }

    protected void writeEntries(FacesContext context, HtmlSchedule schedule, ScheduleDay day, ResponseWriter writer) throws IOException {
        String clientId = schedule.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)schedule, context);
        String formId = parentFormInfo == null ? null : parentFormInfo.getFormName();
        TreeSet<ScheduleEntry> entrySet = new TreeSet<ScheduleEntry>(comparator);
        Iterator entryIterator = day.iterator();
        while (entryIterator.hasNext()) {
            ScheduleEntry entry = (ScheduleEntry)entryIterator.next();
            entrySet.add(entry);
        }
        if (entrySet.size() > 0) {
            writer.startElement("table", (UIComponent)schedule);
            writer.writeAttribute("cellpadding", (Object)"0", null);
            writer.writeAttribute("cellspacing", (Object)"0", null);
            writer.writeAttribute("style", (Object)"width: 100%;", null);
            for (ScheduleEntry entry : entrySet) {
                writer.startElement("tr", (UIComponent)schedule);
                writer.startElement("td", (UIComponent)schedule);
                if (this.isSelected(schedule, entry)) {
                    writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "selected"), null);
                }
                StringBuffer entryStyle = new StringBuffer();
                entryStyle.append("width: 100%;");
                String entryColor = this.getEntryRenderer(schedule).getColor(context, schedule, entry, this.isSelected(schedule, entry));
                if (this.isSelected(schedule, entry) && entryColor != null) {
                    entryStyle.append(" background-color: ");
                    entryStyle.append(entryColor);
                    entryStyle.append(";");
                    entryStyle.append(" border-color: ");
                    entryStyle.append(entryColor);
                    entryStyle.append(";");
                }
                writer.writeAttribute("style", (Object)entryStyle.toString(), null);
                if (schedule.isTooltip()) {
                    this.getEntryRenderer(schedule).renderToolTip(context, writer, schedule, entry, this.isSelected(schedule, entry));
                }
                if (!this.isSelected(schedule, entry) && !schedule.isReadonly()) {
                    writer.startElement("a", (UIComponent)schedule);
                    writer.writeAttribute("href", (Object)"#", null);
                    writer.writeAttribute("onclick", (Object)("fireEntrySelected('" + formId + "', '" + clientId + "', '" + entry.getId() + "');"), null);
                }
                this.getEntryRenderer(schedule).renderContent(context, writer, schedule, day, entry, true, this.isSelected(schedule, entry));
                if (!this.isSelected(schedule, entry) && !schedule.isReadonly()) {
                    writer.endElement("a");
                }
                writer.endElement("td");
                writer.endElement("tr");
            }
            writer.endElement("table");
        }
    }

    protected boolean isSelected(HtmlSchedule schedule, ScheduleEntry entry) {
        ScheduleEntry selectedEntry = schedule.getModel().getSelectedEntry();
        if (selectedEntry == null) {
            return false;
        }
        return selectedEntry.getId().equals(entry.getId());
    }

    protected Date determineLastClickedDate(HtmlSchedule schedule, String dateId, String yPos) {
        String day = dateId.substring(dateId.lastIndexOf("_") + 1);
        Date date = ScheduleUtil.getDateFromId(day, schedule.getModel().getTimeZone());
        Calendar cal = this.getCalendarInstance(schedule, date != null ? date : new Date());
        cal.set(11, schedule.getVisibleStartHour());
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        log.debug((Object)("last clicked datetime: " + cal.getTime()));
        return cal.getTime();
    }
}

