/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesBeanFactory {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FacesBeanFactory.class);
    private static Map<Object, Object> _TYPES_MAP;

    public static FacesBean createFacesBean(Class<?> ownerClass, String rendererType) {
        if (ownerClass == null) {
            return null;
        }
        String className = ownerClass.getName();
        FacesBean bean = FacesBeanFactory.createFacesBean(className, rendererType);
        if (bean == null && rendererType != null) {
            bean = FacesBeanFactory.createFacesBean(className, null);
        }
        if (bean == null) {
            bean = FacesBeanFactory.createFacesBean(ownerClass.getSuperclass(), rendererType);
        }
        return bean;
    }

    public static FacesBean createFacesBean(String beanType, String rendererType) {
        String typeKey = rendererType != null ? beanType + "|" + rendererType : beanType;
        String className = (String)_TYPES_MAP.get(typeKey);
        if (className == null) {
            return null;
        }
        try {
            Class<?> type = FacesBeanFactory._getClassLoader().loadClass(className);
            return (FacesBean)type.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            _LOG.severe("Could not find FacesBean class " + className, cnfe);
        }
        catch (IllegalAccessException iae) {
            _LOG.severe("Could not create instance of FacesBean " + className, iae);
        }
        catch (InstantiationException ie) {
            _LOG.severe("Could not create instance of FacesBean " + className, ie);
        }
        return null;
    }

    private static void _initializeBeanTypes() {
        _TYPES_MAP = new HashMap<Object, Object>();
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> en = FacesBeanFactory._getClassLoader().getResources("META-INF/faces-bean.properties");
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            Collections.reverse(list);
        }
        catch (IOException ioe) {
            _LOG.severe(ioe);
            return;
        }
        if (list.isEmpty() && _LOG.isInfo()) {
            _LOG.info("No faces-bean.properties files located");
        }
        for (URL url : list) {
            FacesBeanFactory._initializeBeanTypes(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _initializeBeanTypes(URL url) {
        try {
            Properties properties = new Properties();
            InputStream is = url.openStream();
            try {
                properties.load(is);
                if (_LOG.isFine()) {
                    _LOG.fine("Loading bean factory info from " + url);
                }
                _TYPES_MAP.putAll(properties);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ioe) {
            _LOG.severe("Could not load " + url, ioe);
        }
    }

    private static ClassLoader _getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = FacesBeanFactory.class.getClassLoader();
        }
        return loader;
    }

    static {
        FacesBeanFactory._initializeBeanTypes();
    }
}

