/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.bean.PropertyMap;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class StateUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StateUtils.class);

    public static Object saveKey(PropertyKey key) {
        int index = key.getIndex();
        if (index < 0) {
            return key.getName();
        }
        if (index < 128) {
            return new Byte((byte)index);
        }
        return new Integer(index);
    }

    public static PropertyKey restoreKey(FacesBean.Type type, Object value) {
        PropertyKey key;
        if (value instanceof Number) {
            key = type.findKey(((Number)value).intValue());
            if (key == null) {
                throw new IllegalStateException("Invalid index");
            }
        } else {
            key = type.findKey((String)value);
            if (key == null) {
                key = PropertyKey.createPropertyKey((String)value);
            }
        }
        return key;
    }

    public static Object saveState(PropertyMap map, FacesContext context, boolean useStateHolder) {
        int size = map.size();
        if (size == 0) {
            return null;
        }
        Object[] values = new Object[2 * size];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            PropertyKey key = (PropertyKey)entry.getKey();
            if (key.isTransient()) continue;
            Object value = entry.getValue();
            values[i] = StateUtils.saveKey(key);
            if (_LOG.isFinest()) {
                _LOG.finest("SAVE {" + key + "=" + value + "}");
            }
            values[i + 1] = useStateHolder ? StateUtils.saveStateHolder(context, value) : key.saveValue(context, value);
            i += 2;
        }
        return values;
    }

    public static void restoreState(PropertyMap map, FacesContext context, FacesBean.Type type, Object state, boolean useStateHolder) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        int size = values.length / 2;
        for (int i = 0; i < size; ++i) {
            Object savedKey = values[i * 2];
            if (savedKey == null) continue;
            Object savedValue = values[i * 2 + 1];
            PropertyKey key = StateUtils.restoreKey(type, savedKey);
            Object value = useStateHolder ? StateUtils.restoreStateHolder(context, savedValue) : key.restoreValue(context, savedValue);
            if (_LOG.isFinest()) {
                _LOG.finest("RESTORE {" + key + "=" + value + "}");
            }
            map.put(key, value);
        }
    }

    public static Object saveStateHolder(FacesContext context, Object value) {
        if (value == null) {
            return null;
        }
        Saver saver = null;
        if (value instanceof StateHolder) {
            if (((StateHolder)value).isTransient()) {
                return null;
            }
            saver = new SHSaver();
        } else {
            if (value instanceof Serializable) {
                return value;
            }
            saver = new Saver();
        }
        if (saver != null) {
            saver.saveState(context, value);
        }
        return saver;
    }

    public static Object restoreStateHolder(FacesContext context, Object savedValue) {
        if (!(savedValue instanceof Saver)) {
            return savedValue;
        }
        return ((Saver)savedValue).restoreState(context);
    }

    public static Object saveList(FacesContext context, Object value) {
        if (value == null) {
            return null;
        }
        List list = (List)value;
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Object[] array = new Object[size];
        int index = 0;
        for (Object object : list) {
            array[index++] = StateUtils.saveStateHolder(context, object);
        }
        return array;
    }

    public static Object restoreList(FacesContext context, Object savedValue) {
        if (savedValue == null) {
            return null;
        }
        Object[] array = (Object[])savedValue;
        int length = array.length;
        if (length == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (Object state : array) {
            Object restored = StateUtils.restoreStateHolder(context, state);
            if (restored == null) continue;
            list.add(restored);
        }
        return list;
    }

    private static ClassLoader _getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = StateUtils.class.getClassLoader();
        }
        return cl;
    }

    private static class SHSaver
    extends Saver {
        private Object _save;

        private SHSaver() {
        }

        public void saveState(FacesContext context, Object value) {
            super.saveState(context, value);
            this._save = ((StateHolder)value).saveState(context);
        }

        public Object restoreState(FacesContext context) {
            Object o = super.restoreState(context);
            if (o != null) {
                ((StateHolder)o).restoreState(context, this._save);
            }
            return o;
        }
    }

    private static class Saver
    implements Serializable {
        private String _name;

        private Saver() {
        }

        public void saveState(FacesContext context, Object saved) {
            this._name = saved.getClass().getName();
        }

        public Object restoreState(FacesContext context) {
            ClassLoader cl = StateUtils._getClassLoader();
            try {
                Class<?> clazz = cl.loadClass(this._name);
                return clazz.newInstance();
            }
            catch (Throwable t) {
                _LOG.severe(t);
                return null;
            }
        }
    }
}

