/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueMap
extends AbstractMap<String, Object> {
    private FacesBean _bean;
    private MakeEntries _entries;

    public ValueMap(FacesBean bean) {
        this._bean = bean;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        PropertyKey propertyKey = this._getPropertyKey(key);
        if (propertyKey.isList()) {
            Class<?> type = propertyKey.getType();
            if (type.isArray()) {
                type = type.getComponentType();
            }
            return this._bean.getEntries(propertyKey, type);
        }
        Object val = this._bean.getProperty(propertyKey);
        return val != null ? val : propertyKey.getDefault();
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this._putInternal(this._getPropertyKey(key), value);
    }

    @Override
    public Object remove(Object key) {
        PropertyKey propertyKey = this._getPropertyKey(key);
        Object oldValue = this._bean.getProperty(propertyKey);
        this._bean.setProperty(propertyKey, null);
        if (this._entries != null) {
            this._entries._keys.remove(propertyKey);
        }
        return oldValue;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this._entries == null) {
            HashSet<PropertyKey> keySet = new HashSet<PropertyKey>();
            keySet.addAll(this._bean.keySet());
            keySet.addAll(this._bean.bindingKeySet());
            this._entries = new MakeEntries(keySet);
        }
        return this._entries;
    }

    private Object _putInternal(PropertyKey propertyKey, Object value) {
        assert (propertyKey != null);
        Object oldValue = this._bean.getProperty(propertyKey);
        this._bean.setProperty(propertyKey, value);
        if (this._entries != null) {
            if (value == null) {
                this._entries._keys.remove(propertyKey);
            } else {
                this._entries._keys.add(propertyKey);
            }
        }
        return oldValue;
    }

    private PropertyKey _getPropertyKey(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            PropertyKey propertyKey = this._bean.getType().findKey(keyString);
            if (propertyKey == null) {
                propertyKey = PropertyKey.createPropertyKey(keyString);
            }
            return propertyKey;
        }
        if (key instanceof PropertyKey) {
            return (PropertyKey)key;
        }
        throw new ClassCastException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryImpl
    implements Map.Entry<String, Object> {
        private final PropertyKey _key;

        public EntryImpl(PropertyKey key) {
            assert (key != null);
            this._key = key;
        }

        @Override
        public String getKey() {
            return this._key.getName();
        }

        @Override
        public Object getValue() {
            return ValueMap.this.get(this._key);
        }

        @Override
        public Object setValue(Object value) {
            return ValueMap.this._putInternal(this._key, value);
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            Object value = this.getValue();
            return this._key.hashCode() ^ (value == null ? 0 : value.hashCode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MakeEntries
    extends AbstractSet<Map.Entry<String, Object>> {
        private Set<PropertyKey> _keys;

        public MakeEntries(Set<PropertyKey> keys) {
            this._keys = keys;
        }

        @Override
        public int size() {
            return this._keys.size();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof EntryImpl)) {
                return false;
            }
            String key = ((EntryImpl)o).getKey();
            this._keys.remove(key);
            return ValueMap.this.remove(key) != null;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            final Iterator<PropertyKey> base = this._keys.iterator();
            return new Iterator<Map.Entry<String, Object>>(){
                private EntryImpl _lastEntry;

                @Override
                public boolean hasNext() {
                    return base.hasNext();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    this._lastEntry = new EntryImpl((PropertyKey)base.next());
                    return this._lastEntry;
                }

                @Override
                public void remove() {
                    if (this._lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    base.remove();
                    ValueMap.this.remove(this._lastEntry.getKey());
                    this._lastEntry = null;
                }
            };
        }
    }
}

