/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.List;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.change.AddComponentChange;
import org.apache.myfaces.trinidad.change.ChangeUtils;

public class AddChildComponentChange
extends AddComponentChange {
    private final String _insertBeforeId;

    public AddChildComponentChange(UIComponent childComponent) {
        this(null, childComponent);
    }

    public AddChildComponentChange(String insertBeforeId, UIComponent childComponent) {
        super(childComponent);
        this._insertBeforeId = insertBeforeId;
    }

    public String getInsertBeforeId() {
        return this._insertBeforeId;
    }

    public void changeComponent(UIComponent uiComponent) {
        UIComponent child = this.getComponent();
        if (child == null) {
            return;
        }
        String newChildId = child.getId();
        List children = uiComponent.getChildren();
        UIComponent removableChild = ChangeUtils.getChildForId(uiComponent, newChildId);
        if (removableChild != null) {
            children.remove(removableChild);
        }
        if (this._insertBeforeId == null) {
            children.add(child);
        } else {
            int index = AddChildComponentChange._getChildIndex(uiComponent, this._insertBeforeId);
            children.add(index, child);
        }
    }

    private static int _getChildIndex(UIComponent parent, String childId) {
        int numChildren = parent.getChildCount();
        if (childId == null) {
            return numChildren;
        }
        UIComponent child = ChangeUtils.getChildForId(parent, childId);
        if (child == null) {
            return numChildren;
        }
        return parent.getChildren().indexOf(child);
    }
}

