/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import org.apache.myfaces.trinidad.change.AddComponentDocumentChange;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AddChildDocumentChange
extends AddComponentDocumentChange {
    private final String _insertBeforeId;

    public AddChildDocumentChange(DocumentFragment componentFragment) {
        this(null, componentFragment);
    }

    public AddChildDocumentChange(String insertBeforeId, DocumentFragment componentFragment) {
        super(componentFragment);
        this._insertBeforeId = insertBeforeId;
    }

    public String getInsertBeforeId() {
        return this._insertBeforeId;
    }

    public void changeDocument(Node componentNode) {
        if (componentNode == null) {
            throw new IllegalArgumentException("No node specified");
        }
        DocumentFragment targetFragment = this.getImportedComponentFragment(componentNode);
        Node insertBeforeNode = null;
        if (this._insertBeforeId != null) {
            String insertBeforeID = this._insertBeforeId;
            for (Node currChild = componentNode.getFirstChild(); currChild != null; currChild = currChild.getNextSibling()) {
                Node idAttr;
                NamedNodeMap attributes = currChild.getAttributes();
                if (attributes == null || (idAttr = attributes.getNamedItem("id")) == null || !insertBeforeID.equals(idAttr.getNodeValue())) continue;
                insertBeforeNode = currChild;
                break;
            }
        }
        componentNode.insertBefore(targetFragment, insertBeforeNode);
    }
}

