/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import org.apache.myfaces.trinidad.change.DocumentChange;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeDocumentChange
implements DocumentChange {
    private final String _attributeName;
    private final String _attributeValueString;

    public AttributeDocumentChange(String attributeName, String attributeValueString) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Cannot construct an AttributeChange with null attribute name.");
        }
        this._attributeName = attributeName;
        this._attributeValueString = attributeValueString;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public Object getAttributeStringValue() {
        return this._attributeValueString;
    }

    public void changeDocument(Node componentNode) {
        NamedNodeMap attributes = componentNode.getAttributes();
        if (attributes != null) {
            if (this._attributeValueString == null) {
                attributes.removeNamedItem(this._attributeName);
            } else {
                ((Element)componentNode).setAttribute(this._attributeName, this._attributeValueString);
            }
        }
    }

    public boolean getForcesDocumentReload() {
        return false;
    }
}

