/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseChangeManager
extends ChangeManager {
    BaseChangeManager() {
    }

    @Override
    public void addComponentChange(FacesContext facesContext, UIComponent uiComponent, ComponentChange change) {
        if (facesContext == null || uiComponent == null || change == null) {
            throw new IllegalArgumentException("Cannot add a Change with either of facesContext, uiComponent or Change being null.");
        }
        this._addComponentChangeImpl(facesContext, uiComponent, change);
        if (this.supportsDocumentPersistence(facesContext)) {
            DocumentChange docChange = null;
            docChange = change instanceof DocumentChange ? (DocumentChange)((Object)change) : BaseChangeManager.createDocumentChange(change);
            if (docChange != null) {
                this.addDocumentChange(facesContext, uiComponent, docChange);
            }
        }
    }

    @Override
    public Iterator<ComponentChange> getComponentChanges(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent == null) {
            return null;
        }
        String viewId = facesContext.getViewRoot().getViewId();
        Map<String, List<ComponentChange>> componentToChangesMap = this.getComponentToChangesMapForView(facesContext, viewId, false);
        if (componentToChangesMap == null) {
            return null;
        }
        String uniqueIdForComponent = BaseChangeManager._getUniqueIdForComponent(uiComponent);
        List<ComponentChange> changesList = componentToChangesMap.get(uniqueIdForComponent);
        if (changesList == null) {
            return null;
        }
        return changesList.iterator();
    }

    @Override
    public Iterator<String> getComponentIdsWithChanges(FacesContext facesContext) {
        String viewId = facesContext.getViewRoot().getViewId();
        Map<String, List<ComponentChange>> componentToChangesMap = this.getComponentToChangesMapForView(facesContext, viewId, false);
        if (componentToChangesMap == null) {
            return null;
        }
        return componentToChangesMap.keySet().iterator();
    }

    protected abstract Map<String, List<ComponentChange>> getComponentToChangesMapForView(FacesContext var1, String var2, boolean var3);

    private void _addComponentChangeImpl(FacesContext facesContext, UIComponent uiComponent, ComponentChange change) {
        String uniqueIdForComponent;
        String viewId = facesContext.getViewRoot().getViewId();
        Map<String, List<ComponentChange>> componentToChangesMap = this.getComponentToChangesMapForView(facesContext, viewId, true);
        List<ComponentChange> changeListForComponent = componentToChangesMap.get(uniqueIdForComponent = BaseChangeManager._getUniqueIdForComponent(uiComponent));
        if (changeListForComponent == null) {
            changeListForComponent = new LinkedList<ComponentChange>();
            componentToChangesMap.put(uniqueIdForComponent, changeListForComponent);
        }
        changeListForComponent.add(change);
    }

    protected void persistDocumentChanges(FacesContext facesContext) {
    }

    private static String _getUniqueIdForComponent(UIComponent uiComponent) {
        UIComponent ancestor;
        for (ancestor = uiComponent; ancestor != null && !(ancestor instanceof NamingContainer); ancestor = ancestor.getParent()) {
        }
        String namingContainerId = ancestor == null ? "" : ancestor.getId();
        return namingContainerId + ':' + uiComponent.getId();
    }

    protected abstract Document getDocument(FacesContext var1);

    protected boolean supportsDocumentPersistence(FacesContext context) {
        return this.getDocument(context) != null;
    }
}

