/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChangeComponentProxy
implements Serializable {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ChangeComponentProxy.class);
    private transient Class<? extends UIComponent> _class;
    private String _className;
    private Object _state;

    public ChangeComponentProxy(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent == null) {
            throw new IllegalArgumentException("Cannot construct an ChangeComponentProxy with null uiComponent.");
        }
        this._class = uiComponent.getClass();
        this._className = this._class.getName();
        this._state = uiComponent.saveState(facesContext);
    }

    public UIComponent createComponent() {
        UIComponent uic = null;
        Class<? extends UIComponent> clazz = this._getComponentClass();
        if (clazz == null) {
            return null;
        }
        try {
            uic = clazz.newInstance();
            uic.restoreState(FacesContext.getCurrentInstance(), this._state);
        }
        catch (InstantiationException ie) {
            _LOG.warning("Error on trying to create new component instance for " + clazz.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            _LOG.warning("Error on trying to create new component instance for " + clazz.getName(), iae);
        }
        return uic;
    }

    private Class<? extends UIComponent> _getComponentClass() {
        Class<Object> clazz = this._class;
        if (clazz == null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                this._class = clazz = cl.loadClass(this._className);
            }
            catch (ClassNotFoundException e) {
                _LOG.severe(e);
            }
        }
        return clazz;
    }
}

