/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.HashMap;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.change.AttributeDocumentChange;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.apache.myfaces.trinidad.change.DocumentChangeFactory;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeManager {
    private static HashMap<String, String> _CLASSNAME_TO_CONVERTER_NAME_MAP = new HashMap();
    private static HashMap<Class<? extends ComponentChange>, DocumentChangeFactory> _CLASS_TO_CONVERTER_MAP = new HashMap();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ChangeManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDocumentFactory(String targetClassName, String converterClassName) {
        if (targetClassName == null || targetClassName.length() == 0) {
            throw new IllegalArgumentException("target class name must be provided");
        }
        if (converterClassName == null || converterClassName.length() == 0) {
            throw new IllegalArgumentException("converter class name must be provided");
        }
        HashMap<String, String> hashMap = _CLASSNAME_TO_CONVERTER_NAME_MAP;
        synchronized (hashMap) {
            _CLASSNAME_TO_CONVERTER_NAME_MAP.put(targetClassName, converterClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DocumentChange createDocumentChange(ComponentChange change) {
        Class<?> changeClass = change.getClass();
        DocumentChangeFactory converterObject = null;
        DocumentChangeFactory converter = null;
        HashMap<Class<? extends ComponentChange>, DocumentChangeFactory> hashMap = _CLASS_TO_CONVERTER_MAP;
        synchronized (hashMap) {
            converterObject = _CLASS_TO_CONVERTER_MAP.get(changeClass);
        }
        if (converterObject != null) {
            converter = converterObject;
        } else {
            String converterName = null;
            HashMap<String, String> hashMap2 = _CLASSNAME_TO_CONVERTER_NAME_MAP;
            synchronized (hashMap2) {
                converterName = _CLASSNAME_TO_CONVERTER_NAME_MAP.get(changeClass.getName());
            }
            if (converterName != null) {
                block17: {
                    try {
                        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                        Class<?> converterClass = contextClassLoader.loadClass(converterName);
                        if (DocumentChangeFactory.class.isAssignableFrom(converterClass)) {
                            converter = (DocumentChangeFactory)converterClass.newInstance();
                            HashMap<Class<? extends ComponentChange>, DocumentChangeFactory> hashMap3 = _CLASS_TO_CONVERTER_MAP;
                            synchronized (hashMap3) {
                                _CLASS_TO_CONVERTER_MAP.put(changeClass, converter);
                                break block17;
                            }
                        }
                        _LOG.warning("Conversion class:" + converterClass + " not of type " + DocumentChangeFactory.class);
                    }
                    catch (Throwable e) {
                        _LOG.warning("Unable to instantiate converterClass:" + converterName, e);
                    }
                }
                if (converter == null) {
                    _CLASSNAME_TO_CONVERTER_NAME_MAP.remove(converterName);
                    return null;
                }
            }
        }
        if (converter != null) {
            return converter.convert(change);
        }
        return null;
    }

    public abstract void addComponentChange(FacesContext var1, UIComponent var2, ComponentChange var3);

    public void addDocumentChange(FacesContext facesContext, UIComponent uiComponent, DocumentChange change) {
        if (facesContext == null || uiComponent == null || change == null) {
            throw new IllegalArgumentException("Cannot add a Change with either of facesContext, uiComponent or Change being null.");
        }
    }

    public abstract Iterator<ComponentChange> getComponentChanges(FacesContext var1, UIComponent var2);

    public abstract Iterator<String> getComponentIdsWithChanges(FacesContext var1);

    static {
        _CLASS_TO_CONVERTER_MAP.put(AttributeComponentChange.class, new AttributeConverter());
    }

    private static class AttributeConverter
    extends DocumentChangeFactory {
        private AttributeConverter() {
        }

        public DocumentChange convert(ComponentChange compChange) {
            AttributeComponentChange change;
            Object value;
            if (compChange instanceof AttributeComponentChange && ((value = (change = (AttributeComponentChange)compChange).getAttributeValue()) == null || value instanceof CharSequence || value instanceof Number || value instanceof Boolean)) {
                String valueString = value != null ? value.toString() : null;
                return new AttributeDocumentChange(change.getAttributeName(), valueString);
            }
            return null;
        }
    }
}

