/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.List;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.change.ChangeUtils;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RemoveChildComponentChange
extends ComponentChange
implements DocumentChange {
    private final String _childId;

    public RemoveChildComponentChange(String childId) {
        if (childId == null || childId.length() == 0) {
            throw new IllegalArgumentException("Cannot construct a RemoveChildChange with null childId.");
        }
        this._childId = childId;
    }

    public String getChildId() {
        return this._childId;
    }

    public void changeComponent(UIComponent uiComponent) {
        if (uiComponent.getChildCount() == 0) {
            return;
        }
        List children = uiComponent.getChildren();
        children.remove(ChangeUtils.getChildForId(uiComponent, this._childId));
    }

    public void changeDocument(Node componentNode) {
        for (Node currChild = componentNode.getFirstChild(); currChild != null; currChild = currChild.getNextSibling()) {
            Node idAttr;
            NamedNodeMap attributes = currChild.getAttributes();
            if (attributes == null || (idAttr = attributes.getNamedItem("id")) == null || !this._childId.equals(idAttr.getNodeValue())) continue;
            currChild.getParentNode().removeChild(currChild);
            break;
        }
    }

    public boolean getForcesDocumentReload() {
        return false;
    }
}

