/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.Map;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.change.ChangeUtils;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoveFacetComponentChange
extends ComponentChange
implements DocumentChange {
    private final String _facetName;

    public RemoveFacetComponentChange(String facetName) {
        if (facetName == null || facetName.length() == 0) {
            throw new IllegalArgumentException("Cannot construct a RemoveFacetChange with null facetName.");
        }
        this._facetName = facetName;
    }

    public String getFacetName() {
        return this._facetName;
    }

    public void changeComponent(UIComponent uiComponent) {
        Map facets = uiComponent.getFacets();
        facets.remove(this._facetName);
    }

    public void changeDocument(Node componentNode) {
        Element facetElement = ChangeUtils.__getFacetElement(componentNode, this._facetName);
        if (facetElement != null) {
            componentNode.removeChild(facetElement);
        }
    }

    public boolean getForcesDocumentReload() {
        return false;
    }
}

