/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReorderChildrenComponentChange
extends ComponentChange
implements DocumentChange {
    private final List<String> _childIds;

    public ReorderChildrenComponentChange(List<String> childIds) {
        if (childIds == null) {
            throw new IllegalArgumentException("Cannot construct a ReorderChange with null childIds.");
        }
        this._childIds = Collections.unmodifiableList(new ArrayList<String>(childIds));
    }

    public List<String> getChildIds() {
        return this._childIds;
    }

    @Override
    public void changeComponent(UIComponent uiComponent) {
        int childCount = uiComponent.getChildCount();
        if (childCount == 0) {
            return;
        }
        LinkedHashMap<String, UIComponent> childrenMap = new LinkedHashMap<String, UIComponent>();
        List children = uiComponent.getChildren();
        for (UIComponent child : children) {
            childrenMap.put(child.getId(), child);
        }
        children.clear();
        for (String currReorderID : this._childIds) {
            UIComponent currChild = (UIComponent)childrenMap.remove(currReorderID);
            if (currChild == null) continue;
            children.add(currChild);
        }
        children.addAll(childrenMap.values());
    }

    @Override
    public void changeDocument(Node componentNode) {
        LinkedHashMap<String, Node> currChildrenMap = new LinkedHashMap<String, Node>(13);
        Node currChild = componentNode.getFirstChild();
        while (currChild != null) {
            Node idAttr;
            int fakeIndex = 0;
            NamedNodeMap namedNodeMap = currChild.getAttributes();
            String currKey = null;
            if (namedNodeMap != null && (idAttr = namedNodeMap.getNamedItem("id")) != null) {
                currKey = idAttr.getNodeValue();
            }
            if (currKey == null) {
                currKey = new Integer(fakeIndex++).toString();
            }
            currChildrenMap.put(currKey, currChild);
            componentNode.removeChild(currChild);
            currChild = componentNode.getFirstChild();
        }
        for (String string : this._childIds) {
            currChild = (Node)currChildrenMap.remove(string);
            if (currChild == null) continue;
            componentNode.appendChild(currChild);
        }
        for (Map.Entry entry : currChildrenMap.entrySet()) {
            componentNode.appendChild((Node)entry.getValue());
        }
    }

    @Override
    public boolean getForcesDocumentReload() {
        return false;
    }
}

