/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import org.apache.myfaces.trinidad.change.AddComponentDocumentChange;
import org.apache.myfaces.trinidad.change.ChangeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SetFacetChildDocumentChange
extends AddComponentDocumentChange {
    private static final String _JSF_CORE_NAMESPACE = "http://java.sun.com/jsf/core";
    private static final String _XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private final String _facetName;

    public SetFacetChildDocumentChange(String facetName, DocumentFragment fragment) {
        super(fragment);
        if (facetName == null || facetName.length() == 0) {
            throw new IllegalArgumentException("Facet name must be specified");
        }
        this._facetName = facetName;
    }

    public String getFacetName() {
        return this._facetName;
    }

    public void changeDocument(Node componentNode) {
        if (componentNode == null) {
            throw new IllegalArgumentException("No node specified");
        }
        DocumentFragment targetFragment = this.getImportedComponentFragment(componentNode);
        Element facetElement = ChangeUtils.__getFacetElement(componentNode, this._facetName);
        if (facetElement != null) {
            ChangeUtils.__removeAllChildren(facetElement);
        } else {
            Document targetDocument = componentNode.getOwnerDocument();
            facetElement = targetDocument.createElementNS(_JSF_CORE_NAMESPACE, "f:facet");
            facetElement.setAttributeNS(_XMLNS_NAMESPACE, "xmlns:f", _JSF_CORE_NAMESPACE);
            componentNode.appendChild(facetElement);
        }
        facetElement.appendChild(targetFragment);
    }

    public boolean getForcesDocumentReload() {
        return false;
    }
}

