/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXShowDetail;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

final class StampState
implements Externalizable {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StampState.class);
    private Map<DualKey, Object> _rows = Collections.emptyMap();
    private static final Object[] _EMPTY_ARRAY = new Object[0];

    public void clear(Object skipCurrencyObj) {
        if (!this._rows.isEmpty()) {
            Iterator<DualKey> iter = this._rows.keySet().iterator();
            while (iter.hasNext()) {
                DualKey dk = iter.next();
                if (StampState._eq(dk._key1, skipCurrencyObj)) continue;
                iter.remove();
            }
        }
    }

    public void put(Object currencyObj, String key, Object value) {
        Map comparant = Collections.emptyMap();
        if (this._rows == comparant) {
            this._rows = new HashMap<DualKey, Object>(109);
        }
        DualKey dk = new DualKey(currencyObj, key);
        this._rows.put(dk, value);
    }

    public int size() {
        return this._rows.size();
    }

    public Object get(Object currencyObj, String key) {
        DualKey dk = new DualKey(currencyObj, key);
        return this._rows.get(dk);
    }

    public static Object saveStampState(FacesContext context, UIComponent stamp) {
        RowState state = StampState._createState(stamp);
        if (state != null) {
            state.saveRowState(stamp);
        }
        return state;
    }

    public static void restoreStampState(FacesContext context, UIComponent stamp, Object stampState) {
        if (stampState != null) {
            String stampId = stamp.getId();
            stamp.setId(stampId);
            RowState state = (RowState)stampState;
            state.restoreRowState(stamp);
        }
    }

    public static Object saveChildStampState(FacesContext context, UIComponent column, UIXCollection table) {
        List kids = column.getChildren();
        int sz = kids.size();
        Object[] state = new Object[sz];
        boolean wasAllTransient = true;
        for (int i = 0; i < sz; ++i) {
            Object childState;
            state[i] = childState = table.saveStampState(context, (UIComponent)kids.get(i));
            if (childState == UIXCollection.Transient.TRUE) continue;
            wasAllTransient = false;
        }
        if (wasAllTransient) {
            return _EMPTY_ARRAY;
        }
        return state;
    }

    public static void restoreChildStampState(FacesContext context, UIComponent column, UIXCollection table, Object stampState) {
        List kids = column.getChildren();
        Object[] state = (Object[])stampState;
        int childIndex = 0;
        block0: for (int i = 0; i < state.length; ++i) {
            UIComponent child;
            Object childState = state[i];
            if (childState != UIXCollection.Transient.TRUE) {
                while (childIndex < kids.size()) {
                    UIComponent kid = (UIComponent)kids.get(childIndex);
                    ++childIndex;
                    if (kid.isTransient()) continue;
                    table.restoreStampState(context, kid, childState);
                    continue block0;
                }
                continue;
            }
            if (childIndex >= kids.size() || !(child = (UIComponent)kids.get(childIndex)).isTransient()) continue;
            ++childIndex;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._rows.size());
        if (this._rows.isEmpty()) {
            return;
        }
        HashMap<DualKey, Object> map = new HashMap<DualKey, Object>(this._rows.size());
        map.putAll(this._rows);
        if (_LOG.isFinest()) {
            for (Map.Entry entry : map.entrySet()) {
                _LOG.finest("Saving " + entry.getKey() + ", " + entry.getValue());
            }
        }
        out.writeObject(map);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (size > 0) {
            this._rows = (Map)in.readObject();
        }
        if (_LOG.isFinest()) {
            for (Map.Entry<DualKey, Object> entry : this._rows.entrySet()) {
                _LOG.finest("Restoring " + entry.getKey() + ", " + entry.getValue());
            }
        }
    }

    private static RowState _createState(UIComponent child) {
        if (child instanceof EditableValueHolder) {
            return new EVHState();
        }
        if (child instanceof UIXShowDetail) {
            return new SDState();
        }
        if (child instanceof UIXCollection) {
            return new TableState();
        }
        return null;
    }

    private static boolean _eq(Object k1, Object k2) {
        if (k1 == null) {
            return k2 == null;
        }
        return k1.equals(k2);
    }

    private static final class DualKey
    implements Serializable {
        private final Object _key1;
        private final Object _key2;
        private final int _hash;

        public DualKey(Object key1, Object key2) {
            this._key1 = key1;
            this._key2 = key2;
            this._hash = DualKey._hash(key1) + DualKey._hash(key2);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof DualKey) {
                DualKey otherKey = (DualKey)other;
                if (this.hashCode() != otherKey.hashCode()) {
                    return false;
                }
                return StampState._eq(this._key1, otherKey._key1) && StampState._eq(this._key2, otherKey._key2);
            }
            return false;
        }

        public int hashCode() {
            return this._hash;
        }

        public String toString() {
            return "<" + this._key1 + "," + this._key2 + ">";
        }

        private static int _hash(Object k) {
            return k == null ? 0 : k.hashCode();
        }
    }

    private static class EVHState
    extends RowState {
        private Object _submitted;
        private Object _local;
        private boolean _localSet;
        private boolean _valid = true;
        private transient UIComponent _assertStamp = null;

        public void saveRowState(UIComponent child) {
            assert (this._assertIsStampCorrect(child));
            EditableValueHolder evh = (EditableValueHolder)child;
            this._submitted = evh.getSubmittedValue();
            this._localSet = evh.isLocalValueSet();
            this._local = evh.getLocalValue();
            this._valid = evh.isValid();
        }

        public void restoreRowState(UIComponent child) {
            assert (this._assertIsStampCorrect(child));
            EditableValueHolder evh = (EditableValueHolder)child;
            evh.setSubmittedValue(this._submitted);
            evh.setValue(this._local);
            evh.setLocalValueSet(this._localSet);
            evh.setValid(this._valid);
            assert (this._assertStampHonoursState(evh));
        }

        public boolean isNull() {
            return this._valid && !this._localSet && this._submitted == null;
        }

        public String toString() {
            return "EVHState[value=" + this._local + ",submitted=" + this._submitted + "]";
        }

        private boolean _assertStampHonoursState(EditableValueHolder evh) {
            return evh.getSubmittedValue() == this._submitted && evh.getLocalValue() == this._local && evh.isLocalValueSet() == this._localSet && evh.isValid() == this._valid;
        }

        private boolean _assertIsStampCorrect(UIComponent stamp) {
            if (this._assertStamp != null) {
                String stampId = stamp.getId();
                String assertStampId = this._assertStamp.getId();
                assert (assertStampId == null && stampId == null || assertStampId != null && assertStampId.equals(stampId)) : "Current stamp:" + stamp + " with id:" + stamp.getId() + ". Previously stamp was:" + this._assertStamp + " with id:" + this._assertStamp.getId();
            } else {
                this._assertStamp = stamp;
            }
            return true;
        }
    }

    private static final class TableState
    extends RowState {
        private Object _state = null;

        public void saveRowState(UIComponent child) {
            this._state = ((UIXCollection)child).__getMyStampState();
        }

        public void restoreRowState(UIComponent child) {
            ((UIXCollection)child).__setMyStampState(this._state);
        }

        public boolean isNull() {
            return this._state == null;
        }
    }

    private static final class SDState
    extends RowState {
        private static final long serialVersionUID = -8605916495935317932L;
        private boolean _disclosed;

        public void saveRowState(UIComponent child) {
            this._disclosed = ((UIXShowDetail)child).isDisclosed();
        }

        public void restoreRowState(UIComponent child) {
            ((UIXShowDetail)child).setDisclosed(this._disclosed);
        }

        public boolean isNull() {
            return !this._disclosed;
        }

        public String toString() {
            return "SDState[disclosed=" + this._disclosed + "]";
        }
    }

    private static abstract class RowState
    implements Serializable {
        public abstract void saveRowState(UIComponent var1);

        public abstract void restoreRowState(UIComponent var1);

        public abstract boolean isNull();
    }
}

