/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import javax.faces.component.ActionSource;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.DialogSource;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.LaunchEvent;
import org.apache.myfaces.trinidad.event.LaunchListener;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidad.event.ReturnListener;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXCommand
extends UIXComponentBase
implements ActionSource,
DialogSource {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey ACTION_KEY = TYPE.registerKey("action", MethodBinding.class, 9);
    public static final PropertyKey ACTION_LISTENER_KEY = TYPE.registerKey("actionListener", MethodBinding.class, 9);
    public static final PropertyKey RETURN_LISTENER_KEY = TYPE.registerKey("returnListener", MethodBinding.class, 9);
    public static final PropertyKey LAUNCH_LISTENER_KEY = TYPE.registerKey("launchListener", MethodBinding.class, 9);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Command";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Command";

    public UIXCommand() {
        super("org.apache.myfaces.trinidad.Button");
    }

    public void queueEvent(FacesEvent e) {
        if (e instanceof ActionEvent || e instanceof ReturnEvent) {
            if (this.isImmediate()) {
                e.setPhaseId(PhaseId.ANY_PHASE);
            } else {
                e.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ActionEvent) {
            RequestContext afContext = RequestContext.getCurrentInstance();
            afContext.getDialogService().setCurrentLaunchSource(this);
            try {
                super.broadcast(event);
                this.broadcastToMethodBinding(event, this.getActionListener());
                FacesContext context = this.getFacesContext();
                ActionListener defaultActionListener = context.getApplication().getActionListener();
                if (defaultActionListener == null) return;
                defaultActionListener.processAction((ActionEvent)event);
                return;
            }
            finally {
                afContext.getDialogService().setCurrentLaunchSource(null);
            }
        } else {
            super.broadcast(event);
            if (event instanceof LaunchEvent) {
                this.broadcastToMethodBinding(event, this.getLaunchListener());
                boolean useWindow = Boolean.TRUE.equals(this.getAttributes().get("useWindow"));
                ((LaunchEvent)event).launchDialog(useWindow);
                return;
            } else {
                if (!(event instanceof ReturnEvent)) return;
                this.broadcastToMethodBinding(event, this.getReturnListener());
                this.getFacesContext().renderResponse();
            }
        }
    }

    public final MethodBinding getAction() {
        return (MethodBinding)this.getProperty(ACTION_KEY);
    }

    public final void setAction(MethodBinding action) {
        this.setProperty(ACTION_KEY, action);
    }

    public final MethodBinding getActionListener() {
        return (MethodBinding)this.getProperty(ACTION_LISTENER_KEY);
    }

    public final void setActionListener(MethodBinding actionListener) {
        this.setProperty(ACTION_LISTENER_KEY, actionListener);
    }

    public final MethodBinding getReturnListener() {
        return (MethodBinding)this.getProperty(RETURN_LISTENER_KEY);
    }

    public final void setReturnListener(MethodBinding returnListener) {
        this.setProperty(RETURN_LISTENER_KEY, returnListener);
    }

    public final MethodBinding getLaunchListener() {
        return (MethodBinding)this.getProperty(LAUNCH_LISTENER_KEY);
    }

    public final void setLaunchListener(MethodBinding launchListener) {
        this.setProperty(LAUNCH_LISTENER_KEY, launchListener);
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY));
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public final void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public final ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public final void addReturnListener(ReturnListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeReturnListener(ReturnListener listener) {
        this.removeFacesListener(listener);
    }

    public final ReturnListener[] getReturnListeners() {
        return (ReturnListener[])this.getFacesListeners(ReturnListener.class);
    }

    public final void addLaunchListener(LaunchListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeLaunchListener(LaunchListener listener) {
        this.removeFacesListener(listener);
    }

    public final LaunchListener[] getLaunchListeners() {
        return (LaunchListener[])this.getFacesListeners(LaunchListener.class);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.Command";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXCommand(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.Command", "org.apache.myfaces.trinidad.Button");
    }
}

