/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.component.WrapperEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXComponentRef
extends UIXComponentBase
implements NamingContainer {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey VALUE_KEY = TYPE.registerKey("value");
    public static final PropertyKey COMPONENT_TYPE_KEY = TYPE.registerKey("componentType", String.class);
    public static final PropertyKey VAR_KEY = TYPE.registerKey("var", String.class);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.ComponentRef";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.ComponentRef";
    private transient String _var = null;
    private transient Object _oldValue = Boolean.FALSE;
    private transient Object _oldVar = null;
    private static final String _BINDINGS_VAR = "bindings";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXComponentRef.class);

    public UIXComponentRef() {
        super(null);
    }

    public void queueEvent(FacesEvent event) {
        event = new WrapperEvent(this, event);
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof WrapperEvent) {
            WrapperEvent wrapper = (WrapperEvent)event;
            final FacesEvent wrapped = wrapper.getEvent();
            Runnable runner = new Runnable(){

                public void run() {
                    wrapped.getComponent().broadcast(wrapped);
                }
            };
            FacesContext context = FacesContext.getCurrentInstance();
            this._processPhase(context, runner);
        } else {
            super.broadcast(event);
        }
    }

    public void processDecodes(final FacesContext context) {
        Runnable runner = new Runnable(){

            public void run() {
                UIXComponentRef.super.processDecodes(context);
            }
        };
        this._processPhase(context, runner);
    }

    public void processValidators(final FacesContext context) {
        Runnable runner = new Runnable(){

            public void run() {
                UIXComponentRef.super.processValidators(context);
            }
        };
        this._processPhase(context, runner);
    }

    public void processUpdates(final FacesContext context) {
        Runnable runner = new Runnable(){

            public void run() {
                UIXComponentRef.super.processUpdates(context);
            }
        };
        this._processPhase(context, runner);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this._setupEL(context);
        super.encodeBegin(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        this._resetEL(context);
    }

    private void _setupEL(FacesContext context) {
        UIXComponentRef region = this._getParent();
        if (region != null) {
            Object newValue = region.getValue();
            this._oldValue = TableUtils.setupELVariable(context, _BINDINGS_VAR, newValue);
            String var = this._getVar();
            this._oldVar = TableUtils.setupELVariable(context, var, new AttrMap());
        }
    }

    private void _resetEL(FacesContext context) {
        TableUtils.setupELVariable(context, _BINDINGS_VAR, this._oldValue);
        String var = this._getVar();
        TableUtils.setupELVariable(context, var, this._oldVar);
        this._oldValue = Boolean.FALSE;
        this._oldVar = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processPhase(FacesContext context, Runnable runner) {
        assert (context != null) : "FacesContext is null";
        if (!this.isRendered()) {
            return;
        }
        this._setupEL(context);
        try {
            runner.run();
        }
        finally {
            this._resetEL(context);
        }
    }

    private UIXComponentRef _getParent() {
        for (UIXComponentRef test = this; test != null; test = test.getParent()) {
            if (!(test instanceof UIXComponentRef)) continue;
            return test;
        }
        _LOG.severe("no parent <tr:componentRef> found!");
        return null;
    }

    private String _getVar() {
        if (this._var == null) {
            this._var = this.getVar();
            if (this._var == null) {
                _LOG.fine("var not set");
                this._var = "null";
            }
        }
        return this._var;
    }

    public final Object getValue() {
        return this.getProperty(VALUE_KEY);
    }

    public final void setValue(Object value) {
        this.setProperty(VALUE_KEY, value);
    }

    public final String getComponentType() {
        return ComponentUtils.resolveString(this.getProperty(COMPONENT_TYPE_KEY));
    }

    public final void setComponentType(String componentType) {
        this.setProperty(COMPONENT_TYPE_KEY, componentType);
    }

    public final String getVar() {
        return ComponentUtils.resolveString(this.getProperty(VAR_KEY));
    }

    public final void setVar(String var) {
        this.setProperty(VAR_KEY, var);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.ComponentRef";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXComponentRef(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AttrMap
    extends AbstractMap<Object, Object> {
        private AttrMap() {
        }

        @Override
        public Object get(Object key) {
            FacesContext context = FacesContext.getCurrentInstance();
            assert (UIXComponentRef.this._oldValue != Boolean.FALSE) : "EL variables have not been setup";
            Object currentValue = TableUtils.setupELVariable(context, UIXComponentRef._BINDINGS_VAR, UIXComponentRef.this._oldValue);
            String var = UIXComponentRef.this._getVar();
            Object currentVar = TableUtils.setupELVariable(context, var, UIXComponentRef.this._oldVar);
            UIXComponentRef region = UIXComponentRef.this._getParent();
            Object result = region.getAttributes().get(key);
            TableUtils.setupELVariable(context, UIXComponentRef._BINDINGS_VAR, currentValue);
            TableUtils.setupELVariable(context, var, currentVar);
            return result;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.emptySet();
        }
    }
}

