/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.Iterator;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.FacesMessageWrapper;
import org.apache.myfaces.trinidad.component.UIXValue;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.LabeledFacesMessage;
import org.apache.myfaces.trinidad.util.MessageFactory;

public abstract class UIXEditableValue
extends UIXValue
implements EditableValueHolder {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXValue.TYPE);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class);
    public static final PropertyKey VALID_KEY = TYPE.registerKey("valid", Boolean.class, Boolean.TRUE);
    public static final PropertyKey REQUIRED_KEY = TYPE.registerKey("required", Boolean.class);
    public static final PropertyKey LOCAL_VALUE_SET_KEY = TYPE.registerKey("localValueSet", Boolean.class);
    public static final PropertyKey SUBMITTED_VALUE_KEY = TYPE.registerKey("submittedValue");
    public static final PropertyKey VALIDATOR_KEY = TYPE.registerKey("validator", MethodBinding.class, 9);
    public static final PropertyKey VALUE_CHANGE_LISTENER_KEY = TYPE.registerKey("valueChangeListener", MethodBinding.class, 9);
    public static final PropertyKey REQUIRED_MESSAGE_DETAIL_KEY = TYPE.registerKey("requiredMessageDetail", String.class);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.EditableValue";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.EditableValue";
    public static final PropertyKey VALIDATORS_KEY = TYPE.registerKey("validators", Validator[].class, 4);
    public static final String REQUIRED_MESSAGE_ID = "org.apache.myfaces.trinidad.UIXEditableValue.REQUIRED";
    public static final String CONVERSION_MESSAGE_ID = "org.apache.myfaces.trinidad.UIXEditableValue.CONVERSION";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXEditableValue.class);

    public void resetValue() {
        this.setValue(null);
        this.setSubmittedValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        this.getFacesBean().addEntry(VALIDATORS_KEY, validator);
    }

    public Validator[] getValidators() {
        return (Validator[])this.getFacesBean().getEntries(VALIDATORS_KEY, Validator.class);
    }

    public void removeValidator(Validator validator) {
        this.getFacesBean().removeEntry(VALIDATORS_KEY, validator);
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        Object newValue = null;
        try {
            newValue = this.getConvertedValue(context, submittedValue);
        }
        catch (ConverterException ce) {
            this._addConversionErrorMessage(context, ce, submittedValue);
            this.setValid(false);
        }
        this.validateValue(context, newValue);
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.setValue(newValue);
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previous, newValue));
            }
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ValueChangeEvent) {
            this.broadcastToMethodBinding(event, this.getValueChangeListener());
        }
    }

    public void processDecodes(FacesContext context) {
        this.setValid(true);
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        if (this.isImmediate()) {
            this._executeValidate(context);
        }
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        if (!this.isRendered()) {
            return;
        }
        this.updateModel(context);
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void processValidators(FacesContext context) {
        super.processValidators(context);
        if (!this.isRendered()) {
            return;
        }
        if (!this.isImmediate()) {
            this._executeValidate(context);
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueBinding binding = this.getFacesBean().getValueBinding(VALUE_KEY);
        if (binding == null) {
            return;
        }
        try {
            Object localValue = this.getLocalValue();
            binding.setValue(context, localValue);
            this.setValue(null);
            this.setLocalValueSet(false);
            if (_LOG.isFiner()) {
                _LOG.finer("Wrote value {0} to model {1} in component {2}", new Object[]{localValue, binding.getExpressionString(), this});
            }
        }
        catch (RuntimeException e) {
            if (_LOG.isFine()) {
                _LOG.fine("Error updating binding ({0})", binding.getExpressionString());
                _LOG.fine(e);
            }
            this.setValid(false);
            FacesMessage message = MessageFactory.getMessage(e);
            message = this._wrapMessage(message);
            context.addMessage(this.getClientId(context), message);
        }
    }

    protected void validateValue(FacesContext context, Object newValue) {
        if (!this.isValid()) {
            return;
        }
        if (this.isEmpty(newValue)) {
            if (this.isRequired()) {
                FacesMessage message = this._getRequiredFacesMessage(context);
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
        } else {
            Iterator<? extends Object> validators = this.getFacesBean().entries(VALIDATORS_KEY);
            while (validators.hasNext()) {
                Validator validator = (Validator)validators.next();
                try {
                    validator.validate(context, (UIComponent)this, newValue);
                }
                catch (ValidatorException ve) {
                    this.setValid(false);
                    FacesMessage message = ve.getFacesMessage();
                    if (message == null) continue;
                    message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    message = this._wrapMessage(message);
                    context.addMessage(this.getClientId(context), message);
                }
            }
            MethodBinding validatorBinding = this.getValidator();
            if (validatorBinding != null) {
                try {
                    validatorBinding.invoke(context, new Object[]{context, this, newValue});
                }
                catch (EvaluationException ee) {
                    if (ee.getCause() instanceof ValidatorException) {
                        ValidatorException ve = (ValidatorException)ee.getCause();
                        this.setValid(false);
                        FacesMessage message = ve.getFacesMessage();
                        if (message != null) {
                            message.setSeverity(FacesMessage.SEVERITY_ERROR);
                            message = this._wrapMessage(message);
                            context.addMessage(this.getClientId(context), message);
                        }
                    }
                    throw ee;
                }
            }
        }
    }

    protected String getRequiredMessageKey() {
        return REQUIRED_MESSAGE_ID;
    }

    protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        Renderer renderer = this.getRenderer(context);
        Object newValue = null;
        if (_LOG.isFine()) {
            _LOG.fine("Converting from " + submittedValue + "(" + submittedValue.getClass() + ")");
        }
        if (renderer != null) {
            newValue = renderer.getConvertedValue(context, (UIComponent)this, submittedValue);
            if (_LOG.isFine()) {
                _LOG.fine("Renderer " + renderer + " returned value " + newValue + "(" + (newValue != null ? newValue.getClass().getName() : "null") + ")");
            }
        } else {
            Converter converter;
            newValue = submittedValue instanceof String ? ((converter = this._getConverterWithType(context)) != null ? converter.getAsObject(context, (UIComponent)this, (String)submittedValue) : submittedValue) : submittedValue;
        }
        return newValue;
    }

    protected boolean compareValues(Object previous, Object value) {
        if (this.isEmpty(previous)) {
            return !this.isEmpty(value);
        }
        return !previous.equals(value);
    }

    protected boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof String && ((String)value).trim().length() == 0;
    }

    private void _executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private Object _getLabel() {
        Object o = this.getAttributes().get("label");
        if (o == null) {
            o = this.getValueBinding("label");
        }
        return o;
    }

    private Object _getRequiredMessageDetail() {
        Object o = this.getAttributes().get("requiredMessageDetail");
        if (o == null) {
            o = this.getValueBinding("requiredMessageDetail");
        }
        return o;
    }

    private FacesMessage _getRequiredFacesMessage(FacesContext context) {
        Object customMessageDetail = this._getRequiredMessageDetail();
        Object label = this._getLabel();
        FacesMessage message = MessageFactory.getMessage(context, this.getRequiredMessageKey(), customMessageDetail, new Object[]{label}, label);
        return message;
    }

    private void _addConversionErrorMessage(FacesContext context, ConverterException ce, Object value) {
        FacesMessage message = ce.getFacesMessage();
        if (message == null) {
            Object label = this._getLabel();
            message = MessageFactory.getMessage(context, CONVERSION_MESSAGE_ID, new Object[]{label, value, ce.getMessage()}, label);
        } else {
            message = this._wrapMessage(message);
        }
        context.addMessage(this.getClientId(context), message);
    }

    private Converter _getConverterWithType(FacesContext context) {
        Converter converter = this.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding valueBinding = this.getValueBinding("value");
        if (valueBinding == null) {
            return null;
        }
        Class converterType = valueBinding.getType(context);
        if (converterType == null || converterType == String.class || converterType == Object.class) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private FacesMessage _wrapMessage(FacesMessage original) {
        if (original instanceof LabeledFacesMessage) {
            return original;
        }
        return new FacesMessageWrapper(original, this._getLabel());
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY));
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isValid() {
        return ComponentUtils.resolveBoolean(this.getProperty(VALID_KEY), true);
    }

    public final void setValid(boolean valid) {
        this.setProperty(VALID_KEY, valid ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isRequired() {
        return ComponentUtils.resolveBoolean(this.getProperty(REQUIRED_KEY));
    }

    public final void setRequired(boolean required) {
        this.setProperty(REQUIRED_KEY, required ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isLocalValueSet() {
        return ComponentUtils.resolveBoolean(this.getProperty(LOCAL_VALUE_SET_KEY));
    }

    public final void setLocalValueSet(boolean localValueSet) {
        this.setProperty(LOCAL_VALUE_SET_KEY, localValueSet ? Boolean.TRUE : Boolean.FALSE);
    }

    public final Object getSubmittedValue() {
        return this.getProperty(SUBMITTED_VALUE_KEY);
    }

    public final void setSubmittedValue(Object submittedValue) {
        this.setProperty(SUBMITTED_VALUE_KEY, submittedValue);
    }

    public final MethodBinding getValidator() {
        return (MethodBinding)this.getProperty(VALIDATOR_KEY);
    }

    public final void setValidator(MethodBinding validator) {
        this.setProperty(VALIDATOR_KEY, validator);
    }

    public final MethodBinding getValueChangeListener() {
        return (MethodBinding)this.getProperty(VALUE_CHANGE_LISTENER_KEY);
    }

    public final void setValueChangeListener(MethodBinding valueChangeListener) {
        this.setProperty(VALUE_CHANGE_LISTENER_KEY, valueChangeListener);
    }

    public final String getRequiredMessageDetail() {
        return ComponentUtils.resolveString(this.getProperty(REQUIRED_MESSAGE_DETAIL_KEY));
    }

    public final void setRequiredMessageDetail(String requiredMessageDetail) {
        this.setProperty(REQUIRED_MESSAGE_DETAIL_KEY, requiredMessageDetail);
    }

    public final void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public final void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public final ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.EditableValue";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXEditableValue(String rendererType) {
        super(rendererType);
    }

    protected UIXEditableValue() {
        this(null);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.EditableValue", "org.apache.myfaces.trinidad.EditableValue");
    }
}

