/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIXIterator
extends UIXCollection {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXCollection.TYPE);
    public static final PropertyKey VAR_STATUS_KEY = TYPE.registerKey("varStatus", String.class, 1);
    public static final PropertyKey VALUE_KEY = TYPE.registerKey("value");
    public static final PropertyKey ROWS_KEY = TYPE.registerKey("rows", (Class<?>)Integer.class, new Integer(25));
    public static final PropertyKey FIRST_KEY = TYPE.registerKey("first", (Class<?>)Integer.class, new Integer(0));
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Iterator";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Iterator";

    public UIXIterator() {
        super(null);
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildren(final FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        if (this.getRendererType() != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.encodeChildren(context, (UIComponent)this);
            }
        } else {
            Runner runner = new Runner(){

                protected void process(UIComponent kid) throws IOException {
                    UIXIterator.this.__encodeRecursive(context, kid);
                }
            };
            runner.run();
            Exception exp = runner.exception;
            if (exp != null) {
                if (exp instanceof RuntimeException) {
                    throw (RuntimeException)exp;
                }
                throw (IOException)exp;
            }
        }
    }

    @Override
    protected Map<String, Object> createVarStatusMap() {
        final Map<String, Object> map = super.createVarStatusMap();
        return new AbstractMap<String, Object>(){

            @Override
            public Object get(Object key) {
                if ("begin".equals(key)) {
                    return new Integer(UIXIterator.this.getFirst());
                }
                if ("first".equals(key)) {
                    boolean isFirst = UIXIterator.this.getFirst() == UIXIterator.this.getRowIndex();
                    return isFirst;
                }
                if ("count".equals(key)) {
                    int count = UIXIterator.this.getRowIndex() - UIXIterator.this.getFirst() + 1;
                    return new Integer(count);
                }
                if ("step".equals(key)) {
                    return new Integer(1);
                }
                return map.get(key);
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return map.entrySet();
            }
        };
    }

    @Override
    protected CollectionModel createCollectionModel(CollectionModel current, Object value) {
        CollectionModel model = ModelUtils.toCollectionModel(value);
        model.setRowIndex(-1);
        assert (model.getRowIndex() == -1) : "RowIndex did not reset to -1";
        return model;
    }

    @Override
    protected void processFacetsAndChildren(final FacesContext context, final PhaseId phaseId) {
        Runner runner = new Runner(){

            protected void process(UIComponent kid) {
                UIXIterator.this.processComponent(context, kid, phaseId);
            }
        };
        runner.run();
    }

    @Override
    void __encodeBegin(FacesContext context) throws IOException {
        this._fixupFirst();
        super.__encodeBegin(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _fixupFirst() {
        int first = this.getFirst();
        if (first == 0) {
            return;
        }
        CollectionModel model = this.getCollectionModel();
        int oldIndex = model.getRowIndex();
        try {
            model.setRowIndex(first);
            if (!model.isRowAvailable()) {
                int size = model.getRowCount();
                int rows = this.getRows();
                if (size <= 0 || rows <= 0 || size <= rows) {
                    first = 0;
                } else {
                    first = size - rows;
                    model.setRowIndex(first);
                    if (!model.isRowAvailable()) {
                        first = 0;
                    }
                }
                this.setFirst(first);
            }
        }
        finally {
            model.setRowIndex(oldIndex);
        }
    }

    @Override
    public final String getVarStatus() {
        return ComponentUtils.resolveString(this.getProperty(VAR_STATUS_KEY));
    }

    public final void setVarStatus(String varStatus) {
        this.setProperty(VAR_STATUS_KEY, varStatus);
    }

    @Override
    public final Object getValue() {
        return this.getProperty(VALUE_KEY);
    }

    public final void setValue(Object value) {
        this.setProperty(VALUE_KEY, value);
    }

    public final int getRows() {
        return ComponentUtils.resolveInteger(this.getProperty(ROWS_KEY), 25);
    }

    public final void setRows(int rows) {
        this.setProperty(ROWS_KEY, new Integer(rows));
    }

    public final int getFirst() {
        return ComponentUtils.resolveInteger(this.getProperty(FIRST_KEY), 0);
    }

    public final void setFirst(int first) {
        this.setProperty(FIRST_KEY, new Integer(first));
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.Iterator";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXIterator(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lock();
    }

    private abstract class Runner {
        public Exception exception = null;

        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            List<UIComponent> stamps = UIXIterator.this.getStamps();
            int oldIndex = UIXIterator.this.getRowIndex();
            int first = UIXIterator.this.getFirst();
            int rows = UIXIterator.this.getRows();
            int end = rows <= 0 ? Integer.MAX_VALUE : first + rows;
            try {
                for (int i = first; i < end; ++i) {
                    UIXIterator.this.setRowIndex(i);
                    if (UIXIterator.this.isRowAvailable()) {
                        for (UIComponent stamp : stamps) {
                            this.process(stamp);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                UIXIterator.this.setRowIndex(oldIndex);
            }
        }

        protected abstract void process(UIComponent var1) throws Exception;
    }
}

